<?php

namespace Eurostop\Stocks;

class DeliveryHeaderCustom extends CodedRetrievedDataItemOfDeliveryHeaderDto6qbTdoQxCustom
{

    /**
     * @var string $BranchIdentifier
     */
    protected $BranchIdentifier = null;

    /**
     * @var \DateTime $ConfirmedDate
     */
    protected $ConfirmedDate = null;

    /**
     * @var \DateTime $CreatedDate
     */
    protected $CreatedDate = null;

    /**
     * @var ArrayOfDeliveryDetail $Lines
     */
    protected $Lines = null;

    /**
     * @var string $PurchaseOrderIdentifier
     */
    protected $PurchaseOrderIdentifier = null;

    /**
     * @var string $Reference
     */
    protected $Reference = null;

    /**
     * @var string $SupplierIdentifier
     */
    protected $SupplierIdentifier = null;

    /**
     * @var string $WarehouseIdentifier
     */
    protected $WarehouseIdentifier = null;

    /**
     * @param \DateTime $CreatedDate
     */
    public function __construct(\DateTime $CreatedDate)
    {
      parent::__construct();
      $this->CreatedDate = $CreatedDate->format(\DateTime::ATOM);
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->BranchIdentifier;
    }

    /**
     * @param string $BranchIdentifier
     * @return \Eurostop\Stocks\DeliveryHeader
     */
    public function setBranchIdentifier($BranchIdentifier)
    {
      $this->BranchIdentifier = $BranchIdentifier;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getConfirmedDate()
    {
      if ($this->ConfirmedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ConfirmedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ConfirmedDate
     * @return \Eurostop\Stocks\DeliveryHeader
     */
    public function setConfirmedDate(\DateTime $ConfirmedDate = null)
    {
      if ($ConfirmedDate == null) {
       $this->ConfirmedDate = null;
      } else {
        $this->ConfirmedDate = $ConfirmedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedDate()
    {
      if ($this->CreatedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CreatedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CreatedDate
     * @return \Eurostop\Stocks\DeliveryHeader
     */
    public function setCreatedDate(\DateTime $CreatedDate)
    {
      $this->CreatedDate = $CreatedDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return ArrayOfDeliveryDetail
     */
    public function getLines()
    {
      return $this->Lines;
    }

    /**
     * @param ArrayOfDeliveryDetail $Lines
     * @return \Eurostop\Stocks\DeliveryHeader
     */
    public function setLines($Lines)
    {
      $this->Lines = $Lines;
      return $this;
    }

    /**
     * @return string
     */
    public function getPurchaseOrderIdentifier()
    {
      return $this->PurchaseOrderIdentifier;
    }

    /**
     * @param string $PurchaseOrderIdentifier
     * @return \Eurostop\Stocks\DeliveryHeader
     */
    public function setPurchaseOrderIdentifier($PurchaseOrderIdentifier)
    {
      $this->PurchaseOrderIdentifier = $PurchaseOrderIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getReference()
    {
      return $this->Reference;
    }

    /**
     * @param string $Reference
     * @return \Eurostop\Stocks\DeliveryHeader
     */
    public function setReference($Reference)
    {
      $this->Reference = $Reference;
      return $this;
    }

    /**
     * @return string
     */
    public function getSupplierIdentifier()
    {
      return $this->SupplierIdentifier;
    }

    /**
     * @param string $SupplierIdentifier
     * @return \Eurostop\Stocks\DeliveryHeader
     */
    public function setSupplierIdentifier($SupplierIdentifier)
    {
      $this->SupplierIdentifier = $SupplierIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getWarehouseIdentifier()
    {
      return $this->WarehouseIdentifier;
    }

    /**
     * @param string $WarehouseIdentifier
     * @return \Eurostop\Stocks\DeliveryHeader
     */
    public function setWarehouseIdentifier($WarehouseIdentifier)
    {
      $this->WarehouseIdentifier = $WarehouseIdentifier;
      return $this;
    }

}
