<?php

namespace Eurostop\Stocks;

class ArrayOfSubmittedTransferItem implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var SubmittedTransferItem[] $SubmittedTransferItem
     */
    protected $SubmittedTransferItem = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return SubmittedTransferItem[]
     */
    public function getSubmittedTransferItem()
    {
      return $this->SubmittedTransferItem;
    }

    /**
     * @param SubmittedTransferItem[] $SubmittedTransferItem
     * @return \Eurostop\Stocks\ArrayOfSubmittedTransferItem
     */
    public function setSubmittedTransferItem(array $SubmittedTransferItem = null)
    {
      $this->SubmittedTransferItem = $SubmittedTransferItem;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->SubmittedTransferItem[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return SubmittedTransferItem
     */
    public function offsetGet($offset)
    {
      return $this->SubmittedTransferItem[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param SubmittedTransferItem $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->SubmittedTransferItem[] = $value;
      } else {
        $this->SubmittedTransferItem[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->SubmittedTransferItem[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return SubmittedTransferItem Return the current element
     */
    public function current()
    {
      return current($this->SubmittedTransferItem);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->SubmittedTransferItem);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->SubmittedTransferItem);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->SubmittedTransferItem);
    }

    /**
     * Countable implementation
     *
     * @return SubmittedTransferItem Return count of elements
     */
    public function count()
    {
      return count($this->SubmittedTransferItem);
    }

}
