<?php

namespace Eurostop\Stocks;

class ArrayOfSubmittedTillTransferLine implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var SubmittedTillTransferLine[] $SubmittedTillTransferLine
     */
    protected $SubmittedTillTransferLine = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return SubmittedTillTransferLine[]
     */
    public function getSubmittedTillTransferLine()
    {
      return $this->SubmittedTillTransferLine;
    }

    /**
     * @param SubmittedTillTransferLine[] $SubmittedTillTransferLine
     * @return \Eurostop\Stocks\ArrayOfSubmittedTillTransferLine
     */
    public function setSubmittedTillTransferLine(array $SubmittedTillTransferLine = null)
    {
      $this->SubmittedTillTransferLine = $SubmittedTillTransferLine;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->SubmittedTillTransferLine[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return SubmittedTillTransferLine
     */
    public function offsetGet($offset)
    {
      return $this->SubmittedTillTransferLine[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param SubmittedTillTransferLine $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->SubmittedTillTransferLine[] = $value;
      } else {
        $this->SubmittedTillTransferLine[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->SubmittedTillTransferLine[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return SubmittedTillTransferLine Return the current element
     */
    public function current()
    {
      return current($this->SubmittedTillTransferLine);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->SubmittedTillTransferLine);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->SubmittedTillTransferLine);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->SubmittedTillTransferLine);
    }

    /**
     * Countable implementation
     *
     * @return SubmittedTillTransferLine Return count of elements
     */
    public function count()
    {
      return count($this->SubmittedTillTransferLine);
    }

}
