<?php

namespace Eurostop\Stocks;

class ArrayOfSubmittedStockPosition implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var SubmittedStockPosition[] $SubmittedStockPosition
     */
    protected $SubmittedStockPosition = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return SubmittedStockPosition[]
     */
    public function getSubmittedStockPosition()
    {
      return $this->SubmittedStockPosition;
    }

    /**
     * @param SubmittedStockPosition[] $SubmittedStockPosition
     * @return \Eurostop\Stocks\ArrayOfSubmittedStockPosition
     */
    public function setSubmittedStockPosition(array $SubmittedStockPosition = null)
    {
      $this->SubmittedStockPosition = $SubmittedStockPosition;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->SubmittedStockPosition[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return SubmittedStockPosition
     */
    public function offsetGet($offset)
    {
      return $this->SubmittedStockPosition[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param SubmittedStockPosition $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->SubmittedStockPosition[] = $value;
      } else {
        $this->SubmittedStockPosition[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->SubmittedStockPosition[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return SubmittedStockPosition Return the current element
     */
    public function current()
    {
      return current($this->SubmittedStockPosition);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->SubmittedStockPosition);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->SubmittedStockPosition);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->SubmittedStockPosition);
    }

    /**
     * Countable implementation
     *
     * @return SubmittedStockPosition Return count of elements
     */
    public function count()
    {
      return count($this->SubmittedStockPosition);
    }

}
