<?php

namespace Eurostop\Stocks;

class ArrayOfSubmittedAllocationAction implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var SubmittedAllocationAction[] $SubmittedAllocationAction
     */
    protected $SubmittedAllocationAction = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return SubmittedAllocationAction[]
     */
    public function getSubmittedAllocationAction()
    {
      return $this->SubmittedAllocationAction;
    }

    /**
     * @param SubmittedAllocationAction[] $SubmittedAllocationAction
     * @return \Eurostop\Stocks\ArrayOfSubmittedAllocationAction
     */
    public function setSubmittedAllocationAction(array $SubmittedAllocationAction = null)
    {
      $this->SubmittedAllocationAction = $SubmittedAllocationAction;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->SubmittedAllocationAction[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return SubmittedAllocationAction
     */
    public function offsetGet($offset)
    {
      return $this->SubmittedAllocationAction[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param SubmittedAllocationAction $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->SubmittedAllocationAction[] = $value;
      } else {
        $this->SubmittedAllocationAction[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->SubmittedAllocationAction[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return SubmittedAllocationAction Return the current element
     */
    public function current()
    {
      return current($this->SubmittedAllocationAction);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->SubmittedAllocationAction);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->SubmittedAllocationAction);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->SubmittedAllocationAction);
    }

    /**
     * Countable implementation
     *
     * @return SubmittedAllocationAction Return count of elements
     */
    public function count()
    {
      return count($this->SubmittedAllocationAction);
    }

}
