<?php

namespace Eurostop\Stocks;

class ArrayOfStockForSkuCustom implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var StockForSku[] $StockForSku
     */
    protected $StockForSku = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return StockForSku[]
     */
    public function getStockForSku()
    {
      return $this->StockForSku;
    }

    /**
     * @param StockForSku[] $StockForSku
     * @return \Eurostop\Stocks\ArrayOfStockForSku
     */
    public function setStockForSku(array $StockForSku = null)
    {
      $this->StockForSku = $StockForSku;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->StockForSku[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return StockForSku
     */
    public function offsetGet($offset)
    {
      return $this->StockForSku[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param StockForSku $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->StockForSku[] = $value;
      } else {
        $this->StockForSku[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->StockForSku[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return StockForSku Return the current element
     */
    public function current()
    {
      return current($this->StockForSku);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->StockForSku);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->StockForSku);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->StockForSku);
    }

    /**
     * Countable implementation
     *
     * @return StockForSku Return count of elements
     */
    public function count()
    {
      return count($this->StockForSku);
    }

}
