<?php

namespace Eurostop\Stocks;

class ArrayOfDeliveryHeader implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var DeliveryHeader[] $DeliveryHeader
     */
    protected $DeliveryHeader = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return DeliveryHeader[]
     */
    public function getDeliveryHeader()
    {
      return $this->DeliveryHeader;
    }

    /**
     * @param DeliveryHeader[] $DeliveryHeader
     * @return \Eurostop\Stocks\ArrayOfDeliveryHeader
     */
    public function setDeliveryHeader(array $DeliveryHeader = null)
    {
      $this->DeliveryHeader = $DeliveryHeader;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->DeliveryHeader[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return DeliveryHeader
     */
    public function offsetGet($offset)
    {
      return $this->DeliveryHeader[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param DeliveryHeader $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->DeliveryHeader[] = $value;
      } else {
        $this->DeliveryHeader[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->DeliveryHeader[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return DeliveryHeader Return the current element
     */
    public function current()
    {
      return current($this->DeliveryHeader);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->DeliveryHeader);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->DeliveryHeader);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->DeliveryHeader);
    }

    /**
     * Countable implementation
     *
     * @return DeliveryHeader Return count of elements
     */
    public function count()
    {
      return count($this->DeliveryHeader);
    }

}
