<?php

namespace Eurostop\Stocks;

class ArrayOfDataProcessingResultCustom implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var DataProcessingResult[] $DataProcessingResult
     */
    protected $DataProcessingResult = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return DataProcessingResult[]
     */
    public function getDataProcessingResult()
    {
      return $this->DataProcessingResult;
    }

    /**
     * @param DataProcessingResult[] $DataProcessingResult
     * @return \Eurostop\Stocks\ArrayOfDataProcessingResult
     */
    public function setDataProcessingResult(array $DataProcessingResult = null)
    {
      $this->DataProcessingResult = $DataProcessingResult;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->DataProcessingResult[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return DataProcessingResult
     */
    public function offsetGet($offset)
    {
      return $this->DataProcessingResult[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param DataProcessingResult $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->DataProcessingResult[] = $value;
      } else {
        $this->DataProcessingResult[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->DataProcessingResult[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return DataProcessingResult Return the current element
     */
    public function current()
    {
      return current($this->DataProcessingResult);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->DataProcessingResult);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->DataProcessingResult);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->DataProcessingResult);
    }

    /**
     * Countable implementation
     *
     * @return DataProcessingResult Return count of elements
     */
    public function count()
    {
      return count($this->DataProcessingResult);
    }

}
