<?php

namespace Eurostop\Stocks;

class ArrayOfAllocationHeader implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var AllocationHeader[] $AllocationHeader
     */
    protected $AllocationHeader = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return AllocationHeader[]
     */
    public function getAllocationHeader()
    {
      return $this->AllocationHeader;
    }

    /**
     * @param AllocationHeader[] $AllocationHeader
     * @return \Eurostop\Stocks\ArrayOfAllocationHeader
     */
    public function setAllocationHeader(array $AllocationHeader = null)
    {
      $this->AllocationHeader = $AllocationHeader;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->AllocationHeader[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return AllocationHeader
     */
    public function offsetGet($offset)
    {
      return $this->AllocationHeader[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param AllocationHeader $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->AllocationHeader[] = $value;
      } else {
        $this->AllocationHeader[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->AllocationHeader[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return AllocationHeader Return the current element
     */
    public function current()
    {
      return current($this->AllocationHeader);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->AllocationHeader);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->AllocationHeader);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->AllocationHeader);
    }

    /**
     * Countable implementation
     *
     * @return AllocationHeader Return count of elements
     */
    public function count()
    {
      return count($this->AllocationHeader);
    }

}
