<?php

namespace Eurostop\Stocks;

class AdviceNoteHeader extends CodedRetrievedDataItemOfAdviceNoteHeaderDto6qbTdoQx
{

    /**
     * @var \DateTime $BookedInDate
     */
    protected $BookedInDate = null;

    /**
     * @var string $BranchIdentifier
     */
    protected $BranchIdentifier = null;

    /**
     * @var \DateTime $CreatedDate
     */
    protected $CreatedDate = null;

    /**
     * @var \DateTime $DespatchedDate
     */
    protected $DespatchedDate = null;

    /**
     * @var boolean $IsCancelled
     */
    protected $IsCancelled = null;

    /**
     * @var boolean $IsClosed
     */
    protected $IsClosed = null;

    /**
     * @var ArrayOfAdviceNoteDetail $Lines
     */
    protected $Lines = null;

    /**
     * @var \DateTime $ModifiedDate
     */
    protected $ModifiedDate = null;

    /**
     * @var string $WarehouseIdentifier
     */
    protected $WarehouseIdentifier = null;

    /**
     * @param \DateTime $CreatedDate
     * @param boolean $IsCancelled
     * @param boolean $IsClosed
     */
    public function __construct(\DateTime $CreatedDate, $IsCancelled, $IsClosed)
    {
      parent::__construct();
      $this->CreatedDate = $CreatedDate->format(\DateTime::ATOM);
      $this->IsCancelled = $IsCancelled;
      $this->IsClosed = $IsClosed;
    }

    /**
     * @return \DateTime
     */
    public function getBookedInDate()
    {
      if ($this->BookedInDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->BookedInDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $BookedInDate
     * @return \Eurostop\Stocks\AdviceNoteHeader
     */
    public function setBookedInDate(\DateTime $BookedInDate = null)
    {
      if ($BookedInDate == null) {
       $this->BookedInDate = null;
      } else {
        $this->BookedInDate = $BookedInDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->BranchIdentifier;
    }

    /**
     * @param string $BranchIdentifier
     * @return \Eurostop\Stocks\AdviceNoteHeader
     */
    public function setBranchIdentifier($BranchIdentifier)
    {
      $this->BranchIdentifier = $BranchIdentifier;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedDate()
    {
      if ($this->CreatedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CreatedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CreatedDate
     * @return \Eurostop\Stocks\AdviceNoteHeader
     */
    public function setCreatedDate(\DateTime $CreatedDate)
    {
      $this->CreatedDate = $CreatedDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDespatchedDate()
    {
      if ($this->DespatchedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->DespatchedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $DespatchedDate
     * @return \Eurostop\Stocks\AdviceNoteHeader
     */
    public function setDespatchedDate(\DateTime $DespatchedDate = null)
    {
      if ($DespatchedDate == null) {
       $this->DespatchedDate = null;
      } else {
        $this->DespatchedDate = $DespatchedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsCancelled()
    {
      return $this->IsCancelled;
    }

    /**
     * @param boolean $IsCancelled
     * @return \Eurostop\Stocks\AdviceNoteHeader
     */
    public function setIsCancelled($IsCancelled)
    {
      $this->IsCancelled = $IsCancelled;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsClosed()
    {
      return $this->IsClosed;
    }

    /**
     * @param boolean $IsClosed
     * @return \Eurostop\Stocks\AdviceNoteHeader
     */
    public function setIsClosed($IsClosed)
    {
      $this->IsClosed = $IsClosed;
      return $this;
    }

    /**
     * @return ArrayOfAdviceNoteDetail
     */
    public function getLines()
    {
      return $this->Lines;
    }

    /**
     * @param ArrayOfAdviceNoteDetail $Lines
     * @return \Eurostop\Stocks\AdviceNoteHeader
     */
    public function setLines($Lines)
    {
      $this->Lines = $Lines;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedDate()
    {
      if ($this->ModifiedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ModifiedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ModifiedDate
     * @return \Eurostop\Stocks\AdviceNoteHeader
     */
    public function setModifiedDate(\DateTime $ModifiedDate = null)
    {
      if ($ModifiedDate == null) {
       $this->ModifiedDate = null;
      } else {
        $this->ModifiedDate = $ModifiedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getWarehouseIdentifier()
    {
      return $this->WarehouseIdentifier;
    }

    /**
     * @param string $WarehouseIdentifier
     * @return \Eurostop\Stocks\AdviceNoteHeader
     */
    public function setWarehouseIdentifier($WarehouseIdentifier)
    {
      $this->WarehouseIdentifier = $WarehouseIdentifier;
      return $this;
    }

}
