<?php

namespace Eurostop\Status;

class StatusWebServiceInterfacePluginCustom extends \SoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
      'ArrayOfDataProcessingResult' => 'Eurostop\\Status\\ArrayOfDataProcessingResultCustom',
      'DataProcessingResult' => 'Eurostop\\Status\\DataProcessingResultCustom',
      'ArrayOfDataProcessingStatus' => 'Eurostop\\Status\\ArrayOfDataProcessingStatusCustom',
      'DataProcessingStatus' => 'Eurostop\\Status\\DataProcessingStatusCustom',
      'SystemInformation' => 'Eurostop\\Status\\SystemInformation',
      'GetDataProcessingStatusByReference' => 'Eurostop\\Status\\GetDataProcessingStatusByReferenceCustom',
      'GetDataProcessingStatusByReferenceResponse' => 'Eurostop\\Status\\GetDataProcessingStatusByReferenceResponseCustom',
      'GetDataProcessingStatusByReferenceAndItem' => 'Eurostop\\Status\\GetDataProcessingStatusByReferenceAndItemCustom',
      'GetDataProcessingStatusByReferenceAndItemResponse' => 'Eurostop\\Status\\GetDataProcessingStatusByReferenceAndItemResponseCustom',
      'GetDataProcessingStatusByToken' => 'Eurostop\\Status\\GetDataProcessingStatusByTokenCustom',
      'GetDataProcessingStatusByTokenResponse' => 'Eurostop\\Status\\GetDataProcessingStatusByTokenResponseCustom',
      'GetDataProcessingStatusByTokenAndItem' => 'Eurostop\\Status\\GetDataProcessingStatusByTokenAndItemCustom',
      'GetDataProcessingStatusByTokenAndItemResponse' => 'Eurostop\\Status\\GetDataProcessingStatusByTokenAndItemResponseCustom',
      'GetSystemInformation' => 'Eurostop\\Status\\GetSystemInformation',
      'GetSystemInformationResponse' => 'Eurostop\\Status\\GetSystemInformationResponse',
    );

    /**
     * @param array $options A array of config values
     * @param string $wsdl The wsdl file to use
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
      'features' => 1,
    ), $options);
      if (!$wsdl) {
        $wsdl = 'https://database-test.eurostop.jdsportscanada.com:9120/e-interface/status?wsdl';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * @param GetDataProcessingStatusByReferenceCustom $parameters
     * @return GetDataProcessingStatusByReferenceResponse
     */
    public function GetDataProcessingStatusByReference($parameters)
    {
      return $this->__soapCall('GetDataProcessingStatusByReference', array($parameters));
    }

    /**
     * @param GetDataProcessingStatusByReferenceAndItemCustom $parameters
     * @return GetDataProcessingStatusByReferenceAndItemResponse
     */
    public function GetDataProcessingStatusByReferenceAndItem($parameters)
    {
      return $this->__soapCall('GetDataProcessingStatusByReferenceAndItem', array($parameters));
    }

    /**
     * @param GetDataProcessingStatusByTokenCustom $parameters
     * @return GetDataProcessingStatusByTokenResponse
     */
    public function GetDataProcessingStatusByToken($parameters)
    {
      return $this->__soapCall('GetDataProcessingStatusByToken', array($parameters));
    }

    /**
     * @param GetDataProcessingStatusByTokenAndItemCustom $parameters
     * @return GetDataProcessingStatusByTokenAndItemResponse
     */
    public function GetDataProcessingStatusByTokenAndItem($parameters)
    {
      return $this->__soapCall('GetDataProcessingStatusByTokenAndItem', array($parameters));
    }

    /**
     * @param GetSystemInformation $parameters
     * @return GetSystemInformationResponse
     */
    public function GetSystemInformation(GetSystemInformation $parameters)
    {
      return $this->__soapCall('GetSystemInformation', array($parameters));
    }

}
