<?php

namespace Eurostop\Status;

class StatusWebServiceInterfacePlugin extends \SoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
      'ArrayOfDataProcessingResult' => 'Eurostop\\Status\\ArrayOfDataProcessingResult',
      'DataProcessingResult' => 'Eurostop\\Status\\DataProcessingResult',
      'ArrayOfDataProcessingStatus' => 'Eurostop\\Status\\ArrayOfDataProcessingStatus',
      'DataProcessingStatus' => 'Eurostop\\Status\\DataProcessingStatus',
      'GetDataProcessingStatusByReference' => 'Eurostop\\Status\\GetDataProcessingStatusByReference',
      'GetDataProcessingStatusByReferenceResponse' => 'Eurostop\\Status\\GetDataProcessingStatusByReferenceResponse',
      'GetDataProcessingStatusByReferenceAndItem' => 'Eurostop\\Status\\GetDataProcessingStatusByReferenceAndItem',
      'GetDataProcessingStatusByReferenceAndItemResponse' => 'Eurostop\\Status\\GetDataProcessingStatusByReferenceAndItemResponse',
      'GetDataProcessingStatusByToken' => 'Eurostop\\Status\\GetDataProcessingStatusByToken',
      'GetDataProcessingStatusByTokenResponse' => 'Eurostop\\Status\\GetDataProcessingStatusByTokenResponse',
      'GetDataProcessingStatusByTokenAndItem' => 'Eurostop\\Status\\GetDataProcessingStatusByTokenAndItem',
      'GetDataProcessingStatusByTokenAndItemResponse' => 'Eurostop\\Status\\GetDataProcessingStatusByTokenAndItemResponse',
    );

    /**
     * @param array $options A array of config values
     * @param string $wsdl The wsdl file to use
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
      'stream_context' => NULL,
      'features' => 1,
    ), $options);
      if (!$wsdl) {
        $wsdl = 'https://retailtest.trotters.co.uk:6500/e-interface/status?wsdl';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * @param GetDataProcessingStatusByReference $parameters
     * @return GetDataProcessingStatusByReferenceResponse
     */
    public function GetDataProcessingStatusByReference(GetDataProcessingStatusByReference $parameters)
    {
      return $this->__soapCall('GetDataProcessingStatusByReference', array($parameters));
    }

    /**
     * @param GetDataProcessingStatusByReferenceAndItem $parameters
     * @return GetDataProcessingStatusByReferenceAndItemResponse
     */
    public function GetDataProcessingStatusByReferenceAndItem(GetDataProcessingStatusByReferenceAndItem $parameters)
    {
      return $this->__soapCall('GetDataProcessingStatusByReferenceAndItem', array($parameters));
    }

    /**
     * @param GetDataProcessingStatusByToken $parameters
     * @return GetDataProcessingStatusByTokenResponse
     */
    public function GetDataProcessingStatusByToken(GetDataProcessingStatusByToken $parameters)
    {
      return $this->__soapCall('GetDataProcessingStatusByToken', array($parameters));
    }

    /**
     * @param GetDataProcessingStatusByTokenAndItem $parameters
     * @return GetDataProcessingStatusByTokenAndItemResponse
     */
    public function GetDataProcessingStatusByTokenAndItem(GetDataProcessingStatusByTokenAndItem $parameters)
    {
      return $this->__soapCall('GetDataProcessingStatusByTokenAndItem', array($parameters));
    }

}
