<?php

namespace Eurostop\Status;

class GetDataProcessingStatusByTokenAndItemCustom
{

    /**
     * @var string $submissionToken
     */
    protected $submissionToken = null;

    /**
     * @var ProcessingStatus $itemStatusCode
     */
    protected $itemStatusCode = null;

    /**
     * @var string $dataItemIdentifier
     */
    protected $dataItemIdentifier = null;

    /**
     * @param string $submissionToken
     * @param ProcessingStatus $itemStatusCode
     * @param string $dataItemIdentifier
     */
    public function __construct($submissionToken, $itemStatusCode, $dataItemIdentifier)
    {
      $this->submissionToken = $submissionToken;
      $this->itemStatusCode = $itemStatusCode;
      $this->dataItemIdentifier = $dataItemIdentifier;
    }

    /**
     * @return string
     */
    public function getSubmissionToken()
    {
      return $this->submissionToken;
    }

    /**
     * @param string $submissionToken
     * @return \Eurostop\Status\GetDataProcessingStatusByTokenAndItem
     */
    public function setSubmissionToken($submissionToken)
    {
      $this->submissionToken = $submissionToken;
      return $this;
    }

    /**
     * @return ProcessingStatus
     */
    public function getItemStatusCode()
    {
      return $this->itemStatusCode;
    }

    /**
     * @param ProcessingStatus $itemStatusCode
     * @return \Eurostop\Status\GetDataProcessingStatusByTokenAndItem
     */
    public function setItemStatusCode($itemStatusCode)
    {
      $this->itemStatusCode = $itemStatusCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getDataItemIdentifier()
    {
      return $this->dataItemIdentifier;
    }

    /**
     * @param string $dataItemIdentifier
     * @return \Eurostop\Status\GetDataProcessingStatusByTokenAndItem
     */
    public function setDataItemIdentifier($dataItemIdentifier)
    {
      $this->dataItemIdentifier = $dataItemIdentifier;
      return $this;
    }

}
