<?php

namespace Eurostop\Security;

class RenewAuthTokenCustom
{

    /**
     * @var string $userName
     */
    protected $userName = null;

    /**
     * @var string $password
     */
    protected $password = null;

    /**
     * @var string $authToken
     */
    protected $authToken = null;

    /**
     * @param string $userName
     * @param string $password
     * @param string $authToken
     */
    public function __construct($userName = null, $password = null, $authToken = null)
    {
      $this->userName = $userName;
      $this->password = $password;
      $this->authToken = $authToken;
    }

    /**
     * @return string
     */
    public function getUserName()
    {
      return $this->userName;
    }

    /**
     * @param string $userName
     * @return \Eurostop\Security\RenewAuthToken
     */
    public function setUserName($userName)
    {
      $this->userName = $userName;
      return $this;
    }

    /**
     * @return string
     */
    public function getPassword()
    {
      return $this->password;
    }

    /**
     * @param string $password
     * @return \Eurostop\Security\RenewAuthToken
     */
    public function setPassword($password)
    {
      $this->password = $password;
      return $this;
    }

    /**
     * @return string
     */
    public function getAuthToken()
    {
      return $this->authToken;
    }

    /**
     * @param string $authToken
     * @return \Eurostop\Security\RenewAuthToken
     */
    public function setAuthToken($authToken)
    {
      $this->authToken = $authToken;
      return $this;
    }

}
