<?php

namespace Eurostop\Sales;

class SubmittedReceiptLineSkuCustom extends SubmittedDataItemOfSubmittedReceiptLineSkuDtonkuuQA70Custom
{

    /**
     * @var string $AssistantUsername
     */
    protected $AssistantUsername = null;

    /**
     * @var boolean $IsVoided
     */
    protected $IsVoided = null;

    /**
     * @var int $LineNumber
     */
    protected $LineNumber = null;

    /**
     * @var ReceiptLineType $LineType
     */
    protected $LineType = null;

    /**
     * @var string $ReasonIdentifier
     */
    protected $ReasonIdentifier = null;

    /**
     * @var ReasonIdentifierType $ReasonIdentifierType
     */
    protected $ReasonIdentifierType = null;

    /**
     * @var string $RefundRecallBranchIdentifier
     */
    protected $RefundRecallBranchIdentifier = null;

    /**
     * @var int $RefundRecallLineNumber
     */
    protected $RefundRecallLineNumber = null;

    /**
     * @var string $RefundRecallReceiptIdentifier
     */
    protected $RefundRecallReceiptIdentifier = null;

    /**
     * @var int $RefundRecallTillNumber
     */
    protected $RefundRecallTillNumber = null;

    /**
     * @var string $SalesPersonUsername
     */
    protected $SalesPersonUsername = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var SkuIdentifierType $SkuIdentifierType
     */
    protected $SkuIdentifierType = null;

    /**
     * @var float $SoldValue
     */
    protected $SoldValue = null;

    /**
     * @var int $Units
     */
    protected $Units = null;

    /**
     * @var float $Value
     */
    protected $Value = null;

    /**
     * @var float $VatValue
     */
    protected $VatValue = null;

    /**
     * @param boolean $IsVoided
     * @param int $LineNumber
     * @param ReceiptLineType $LineType
     * @param ReasonIdentifierType $ReasonIdentifierType
     * @param SkuIdentifierType $SkuIdentifierType
     * @param float $SoldValue
     * @param int $Units
     * @param float $Value
     */
    public function __construct($IsVoided, $LineNumber, $LineType, $ReasonIdentifierType, $SkuIdentifierType, $SoldValue, $Units, $Value)
    {
      parent::__construct();
      $this->IsVoided = $IsVoided;
      $this->LineNumber = $LineNumber;
      $this->LineType = $LineType;
      $this->ReasonIdentifierType = $ReasonIdentifierType;
      $this->SkuIdentifierType = $SkuIdentifierType;
      $this->SoldValue = $SoldValue;
      $this->Units = $Units;
      $this->Value = $Value;
    }

    /**
     * @return string
     */
    public function getAssistantUsername()
    {
      return $this->AssistantUsername;
    }

    /**
     * @param string $AssistantUsername
     * @return \Eurostop\Sales\SubmittedReceiptLineSku
     */
    public function setAssistantUsername($AssistantUsername)
    {
      $this->AssistantUsername = $AssistantUsername;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsVoided()
    {
      return $this->IsVoided;
    }

    /**
     * @param boolean $IsVoided
     * @return \Eurostop\Sales\SubmittedReceiptLineSku
     */
    public function setIsVoided($IsVoided)
    {
      $this->IsVoided = $IsVoided;
      return $this;
    }

    /**
     * @return int
     */
    public function getLineNumber()
    {
      return $this->LineNumber;
    }

    /**
     * @param int $LineNumber
     * @return \Eurostop\Sales\SubmittedReceiptLineSku
     */
    public function setLineNumber($LineNumber)
    {
      $this->LineNumber = $LineNumber;
      return $this;
    }

    /**
     * @return ReceiptLineType
     */
    public function getLineType()
    {
      return $this->LineType;
    }

    /**
     * @param ReceiptLineType $LineType
     * @return \Eurostop\Sales\SubmittedReceiptLineSku
     */
    public function setLineType($LineType)
    {
      $this->LineType = $LineType;
      return $this;
    }

    /**
     * @return string
     */
    public function getReasonIdentifier()
    {
      return $this->ReasonIdentifier;
    }

    /**
     * @param string $ReasonIdentifier
     * @return \Eurostop\Sales\SubmittedReceiptLineSku
     */
    public function setReasonIdentifier($ReasonIdentifier)
    {
      $this->ReasonIdentifier = $ReasonIdentifier;
      return $this;
    }

    /**
     * @return ReasonIdentifierType
     */
    public function getReasonIdentifierType()
    {
      return $this->ReasonIdentifierType;
    }

    /**
     * @param ReasonIdentifierType $ReasonIdentifierType
     * @return \Eurostop\Sales\SubmittedReceiptLineSku
     */
    public function setReasonIdentifierType($ReasonIdentifierType)
    {
      $this->ReasonIdentifierType = $ReasonIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getRefundRecallBranchIdentifier()
    {
      return $this->RefundRecallBranchIdentifier;
    }

    /**
     * @param string $RefundRecallBranchIdentifier
     * @return \Eurostop\Sales\SubmittedReceiptLineSku
     */
    public function setRefundRecallBranchIdentifier($RefundRecallBranchIdentifier)
    {
      $this->RefundRecallBranchIdentifier = $RefundRecallBranchIdentifier;
      return $this;
    }

    /**
     * @return int
     */
    public function getRefundRecallLineNumber()
    {
      return $this->RefundRecallLineNumber;
    }

    /**
     * @param int $RefundRecallLineNumber
     * @return \Eurostop\Sales\SubmittedReceiptLineSku
     */
    public function setRefundRecallLineNumber($RefundRecallLineNumber)
    {
      $this->RefundRecallLineNumber = $RefundRecallLineNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getRefundRecallReceiptIdentifier()
    {
      return $this->RefundRecallReceiptIdentifier;
    }

    /**
     * @param string $RefundRecallReceiptIdentifier
     * @return \Eurostop\Sales\SubmittedReceiptLineSku
     */
    public function setRefundRecallReceiptIdentifier($RefundRecallReceiptIdentifier)
    {
      $this->RefundRecallReceiptIdentifier = $RefundRecallReceiptIdentifier;
      return $this;
    }

    /**
     * @return int
     */
    public function getRefundRecallTillNumber()
    {
      return $this->RefundRecallTillNumber;
    }

    /**
     * @param int $RefundRecallTillNumber
     * @return \Eurostop\Sales\SubmittedReceiptLineSku
     */
    public function setRefundRecallTillNumber($RefundRecallTillNumber)
    {
      $this->RefundRecallTillNumber = $RefundRecallTillNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getSalesPersonUsername()
    {
      return $this->SalesPersonUsername;
    }

    /**
     * @param string $SalesPersonUsername
     * @return \Eurostop\Sales\SubmittedReceiptLineSku
     */
    public function setSalesPersonUsername($SalesPersonUsername)
    {
      $this->SalesPersonUsername = $SalesPersonUsername;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Sales\SubmittedReceiptLineSku
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return SkuIdentifierType
     */
    public function getSkuIdentifierType()
    {
      return $this->SkuIdentifierType;
    }

    /**
     * @param SkuIdentifierType $SkuIdentifierType
     * @return \Eurostop\Sales\SubmittedReceiptLineSku
     */
    public function setSkuIdentifierType($SkuIdentifierType)
    {
      $this->SkuIdentifierType = $SkuIdentifierType;
      return $this;
    }

    /**
     * @return float
     */
    public function getSoldValue()
    {
      return $this->SoldValue;
    }

    /**
     * @param float $SoldValue
     * @return \Eurostop\Sales\SubmittedReceiptLineSku
     */
    public function setSoldValue($SoldValue)
    {
      $this->SoldValue = $SoldValue;
      return $this;
    }

    /**
     * @return int
     */
    public function getUnits()
    {
      return $this->Units;
    }

    /**
     * @param int $Units
     * @return \Eurostop\Sales\SubmittedReceiptLineSku
     */
    public function setUnits($Units)
    {
      $this->Units = $Units;
      return $this;
    }

    /**
     * @return float
     */
    public function getValue()
    {
      return $this->Value;
    }

    /**
     * @param float $Value
     * @return \Eurostop\Sales\SubmittedReceiptLineSku
     */
    public function setValue($Value)
    {
      $this->Value = $Value;
      return $this;
    }

    /**
     * @return float
     */
    public function getVatValue()
    {
      return $this->VatValue;
    }

    /**
     * @param float $VatValue
     * @return \Eurostop\Sales\SubmittedReceiptLineSku
     */
    public function setVatValue($VatValue)
    {
      $this->VatValue = $VatValue;
      return $this;
    }

}
