<?php

namespace Eurostop\Sales;

class SubmitReceipt
{

    /**
     * @var SubmittedReceiptHeader $receipt
     */
    protected $receipt = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedReceiptHeader $receipt
     * @param string $submissionReference
     */
    public function __construct($receipt = null, $submissionReference = null)
    {
      $this->receipt = $receipt;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedReceiptHeader
     */
    public function getReceipt()
    {
      return $this->receipt;
    }

    /**
     * @param SubmittedReceiptHeader $receipt
     * @return \Eurostop\Sales\SubmitReceipt
     */
    public function setReceipt($receipt)
    {
      $this->receipt = $receipt;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Sales\SubmitReceipt
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
