<?php

namespace Eurostop\Sales;

class ReceiptLineSku extends RetrievedDataItemOfReceiptLineSkuDtonkuuQA70
{

    /**
     * @var string $AssistantIdentifier
     */
    protected $AssistantIdentifier = null;

    /**
     * @var float $BranchSkuTaxRate
     */
    protected $BranchSkuTaxRate = null;

    /**
     * @var float $BranchSkuTaxThreshold
     */
    protected $BranchSkuTaxThreshold = null;

    /**
     * @var string $EnteredSkuCode
     */
    protected $EnteredSkuCode = null;

    /**
     * @var ReceiptLineEntryMethod $EntryMethod
     */
    protected $EntryMethod = null;

    /**
     * @var boolean $ExportSaleItem
     */
    protected $ExportSaleItem = null;

    /**
     * @var boolean $IsRejected
     */
    protected $IsRejected = null;

    /**
     * @var boolean $IsVoided
     */
    protected $IsVoided = null;

    /**
     * @var int $LineNumber
     */
    protected $LineNumber = null;

    /**
     * @var ReceiptLineType $LineType
     */
    protected $LineType = null;

    /**
     * @var ArrayOfReceiptLinePriceModifier $PriceModifiers
     */
    protected $PriceModifiers = null;

    /**
     * @var string $ProductIdentifier
     */
    protected $ProductIdentifier = null;

    /**
     * @var string $RefundRecallBranchCode
     */
    protected $RefundRecallBranchCode = null;

    /**
     * @var int $RefundRecallLineNumber
     */
    protected $RefundRecallLineNumber = null;

    /**
     * @var string $RefundRecallReceiptNumber
     */
    protected $RefundRecallReceiptNumber = null;

    /**
     * @var int $RefundRecallTillNumber
     */
    protected $RefundRecallTillNumber = null;

    /**
     * @var string $SalesPersonIdentifier
     */
    protected $SalesPersonIdentifier = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var float $SoldValue
     */
    protected $SoldValue = null;

    /**
     * @var float $TotalPriceModifiers
     */
    protected $TotalPriceModifiers = null;

    /**
     * @var string $TypeCode
     */
    protected $TypeCode = null;

    /**
     * @var string $TypeDescription
     */
    protected $TypeDescription = null;

    /**
     * @var string $TypeSubCode
     */
    protected $TypeSubCode = null;

    /**
     * @var float $UnitSoldValue
     */
    protected $UnitSoldValue = null;

    /**
     * @var float $UnitValue
     */
    protected $UnitValue = null;

    /**
     * @var int $Units
     */
    protected $Units = null;

    /**
     * @var float $Value
     */
    protected $Value = null;

    /**
     * @var float $VatPercentage
     */
    protected $VatPercentage = null;

    /**
     * @var string $VatRateIdentifier
     */
    protected $VatRateIdentifier = null;

    /**
     * @var float $VatValue
     */
    protected $VatValue = null;

    
    public function __construct()
    {
      parent::__construct();
    }

    /**
     * @return string
     */
    public function getAssistantIdentifier()
    {
      return $this->AssistantIdentifier;
    }

    /**
     * @param string $AssistantIdentifier
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setAssistantIdentifier($AssistantIdentifier)
    {
      $this->AssistantIdentifier = $AssistantIdentifier;
      return $this;
    }

    /**
     * @return float
     */
    public function getBranchSkuTaxRate()
    {
      return $this->BranchSkuTaxRate;
    }

    /**
     * @param float $BranchSkuTaxRate
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setBranchSkuTaxRate($BranchSkuTaxRate)
    {
      $this->BranchSkuTaxRate = $BranchSkuTaxRate;
      return $this;
    }

    /**
     * @return float
     */
    public function getBranchSkuTaxThreshold()
    {
      return $this->BranchSkuTaxThreshold;
    }

    /**
     * @param float $BranchSkuTaxThreshold
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setBranchSkuTaxThreshold($BranchSkuTaxThreshold)
    {
      $this->BranchSkuTaxThreshold = $BranchSkuTaxThreshold;
      return $this;
    }

    /**
     * @return string
     */
    public function getEnteredSkuCode()
    {
      return $this->EnteredSkuCode;
    }

    /**
     * @param string $EnteredSkuCode
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setEnteredSkuCode($EnteredSkuCode)
    {
      $this->EnteredSkuCode = $EnteredSkuCode;
      return $this;
    }

    /**
     * @return ReceiptLineEntryMethod
     */
    public function getEntryMethod()
    {
      return $this->EntryMethod;
    }

    /**
     * @param ReceiptLineEntryMethod $EntryMethod
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setEntryMethod($EntryMethod)
    {
      $this->EntryMethod = $EntryMethod;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getExportSaleItem()
    {
      return $this->ExportSaleItem;
    }

    /**
     * @param boolean $ExportSaleItem
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setExportSaleItem($ExportSaleItem)
    {
      $this->ExportSaleItem = $ExportSaleItem;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsRejected()
    {
      return $this->IsRejected;
    }

    /**
     * @param boolean $IsRejected
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setIsRejected($IsRejected)
    {
      $this->IsRejected = $IsRejected;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsVoided()
    {
      return $this->IsVoided;
    }

    /**
     * @param boolean $IsVoided
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setIsVoided($IsVoided)
    {
      $this->IsVoided = $IsVoided;
      return $this;
    }

    /**
     * @return int
     */
    public function getLineNumber()
    {
      return $this->LineNumber;
    }

    /**
     * @param int $LineNumber
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setLineNumber($LineNumber)
    {
      $this->LineNumber = $LineNumber;
      return $this;
    }

    /**
     * @return ReceiptLineType
     */
    public function getLineType()
    {
      return $this->LineType;
    }

    /**
     * @param ReceiptLineType $LineType
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setLineType($LineType)
    {
      $this->LineType = $LineType;
      return $this;
    }

    /**
     * @return ArrayOfReceiptLinePriceModifier
     */
    public function getPriceModifiers()
    {
      return $this->PriceModifiers;
    }

    /**
     * @param ArrayOfReceiptLinePriceModifier $PriceModifiers
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setPriceModifiers($PriceModifiers)
    {
      $this->PriceModifiers = $PriceModifiers;
      return $this;
    }

    /**
     * @return string
     */
    public function getProductIdentifier()
    {
      return $this->ProductIdentifier;
    }

    /**
     * @param string $ProductIdentifier
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setProductIdentifier($ProductIdentifier)
    {
      $this->ProductIdentifier = $ProductIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getRefundRecallBranchCode()
    {
      return $this->RefundRecallBranchCode;
    }

    /**
     * @param string $RefundRecallBranchCode
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setRefundRecallBranchCode($RefundRecallBranchCode)
    {
      $this->RefundRecallBranchCode = $RefundRecallBranchCode;
      return $this;
    }

    /**
     * @return int
     */
    public function getRefundRecallLineNumber()
    {
      return $this->RefundRecallLineNumber;
    }

    /**
     * @param int $RefundRecallLineNumber
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setRefundRecallLineNumber($RefundRecallLineNumber)
    {
      $this->RefundRecallLineNumber = $RefundRecallLineNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getRefundRecallReceiptNumber()
    {
      return $this->RefundRecallReceiptNumber;
    }

    /**
     * @param string $RefundRecallReceiptNumber
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setRefundRecallReceiptNumber($RefundRecallReceiptNumber)
    {
      $this->RefundRecallReceiptNumber = $RefundRecallReceiptNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getRefundRecallTillNumber()
    {
      return $this->RefundRecallTillNumber;
    }

    /**
     * @param int $RefundRecallTillNumber
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setRefundRecallTillNumber($RefundRecallTillNumber)
    {
      $this->RefundRecallTillNumber = $RefundRecallTillNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getSalesPersonIdentifier()
    {
      return $this->SalesPersonIdentifier;
    }

    /**
     * @param string $SalesPersonIdentifier
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setSalesPersonIdentifier($SalesPersonIdentifier)
    {
      $this->SalesPersonIdentifier = $SalesPersonIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return float
     */
    public function getSoldValue()
    {
      return $this->SoldValue;
    }

    /**
     * @param float $SoldValue
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setSoldValue($SoldValue)
    {
      $this->SoldValue = $SoldValue;
      return $this;
    }

    /**
     * @return float
     */
    public function getTotalPriceModifiers()
    {
      return $this->TotalPriceModifiers;
    }

    /**
     * @param float $TotalPriceModifiers
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setTotalPriceModifiers($TotalPriceModifiers)
    {
      $this->TotalPriceModifiers = $TotalPriceModifiers;
      return $this;
    }

    /**
     * @return string
     */
    public function getTypeCode()
    {
      return $this->TypeCode;
    }

    /**
     * @param string $TypeCode
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setTypeCode($TypeCode)
    {
      $this->TypeCode = $TypeCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getTypeDescription()
    {
      return $this->TypeDescription;
    }

    /**
     * @param string $TypeDescription
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setTypeDescription($TypeDescription)
    {
      $this->TypeDescription = $TypeDescription;
      return $this;
    }

    /**
     * @return string
     */
    public function getTypeSubCode()
    {
      return $this->TypeSubCode;
    }

    /**
     * @param string $TypeSubCode
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setTypeSubCode($TypeSubCode)
    {
      $this->TypeSubCode = $TypeSubCode;
      return $this;
    }

    /**
     * @return float
     */
    public function getUnitSoldValue()
    {
      return $this->UnitSoldValue;
    }

    /**
     * @param float $UnitSoldValue
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setUnitSoldValue($UnitSoldValue)
    {
      $this->UnitSoldValue = $UnitSoldValue;
      return $this;
    }

    /**
     * @return float
     */
    public function getUnitValue()
    {
      return $this->UnitValue;
    }

    /**
     * @param float $UnitValue
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setUnitValue($UnitValue)
    {
      $this->UnitValue = $UnitValue;
      return $this;
    }

    /**
     * @return int
     */
    public function getUnits()
    {
      return $this->Units;
    }

    /**
     * @param int $Units
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setUnits($Units)
    {
      $this->Units = $Units;
      return $this;
    }

    /**
     * @return float
     */
    public function getValue()
    {
      return $this->Value;
    }

    /**
     * @param float $Value
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setValue($Value)
    {
      $this->Value = $Value;
      return $this;
    }

    /**
     * @return float
     */
    public function getVatPercentage()
    {
      return $this->VatPercentage;
    }

    /**
     * @param float $VatPercentage
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setVatPercentage($VatPercentage)
    {
      $this->VatPercentage = $VatPercentage;
      return $this;
    }

    /**
     * @return string
     */
    public function getVatRateIdentifier()
    {
      return $this->VatRateIdentifier;
    }

    /**
     * @param string $VatRateIdentifier
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setVatRateIdentifier($VatRateIdentifier)
    {
      $this->VatRateIdentifier = $VatRateIdentifier;
      return $this;
    }

    /**
     * @return float
     */
    public function getVatValue()
    {
      return $this->VatValue;
    }

    /**
     * @param float $VatValue
     * @return \Eurostop\Sales\ReceiptLineSku
     */
    public function setVatValue($VatValue)
    {
      $this->VatValue = $VatValue;
      return $this;
    }

}
