<?php

namespace Eurostop\Sales;

class ReceiptHeader extends CodedRetrievedDataItemOfReceiptHeaderDtonkuuQA70
{

    /**
     * @var string $AssistantUsername
     */
    protected $AssistantUsername = null;

    /**
     * @var DateTimeOffset $BeginDateTime
     */
    protected $BeginDateTime = null;

    /**
     * @var string $BranchIdentifier
     */
    protected $BranchIdentifier = null;

    /**
     * @var \DateTime $CreatedDate
     */
    protected $CreatedDate = null;

    /**
     * @var string $CustomerAccountNumber
     */
    protected $CustomerAccountNumber = null;

    /**
     * @var string $CustomerAccountType
     */
    protected $CustomerAccountType = null;

    /**
     * @var string $CustomerIdentifier
     */
    protected $CustomerIdentifier = null;

    /**
     * @var string $CustomerOrderIdentifier
     */
    protected $CustomerOrderIdentifier = null;

    /**
     * @var DateTimeOffset $EndDateTime
     */
    protected $EndDateTime = null;

    /**
     * @var string $ExternalTransactionId
     */
    protected $ExternalTransactionId = null;

    /**
     * @var ArrayOfReceiptGiftCardTransaction $GiftCardTransactions
     */
    protected $GiftCardTransactions = null;

    /**
     * @var string $GiroSlipNumber
     */
    protected $GiroSlipNumber = null;

    /**
     * @var ArrayOfReceiptLineSku $Lines
     */
    protected $Lines = null;

    /**
     * @var string $LinkedReceiptBranchIdentifier
     */
    protected $LinkedReceiptBranchIdentifier = null;

    /**
     * @var string $LinkedReceiptNumber
     */
    protected $LinkedReceiptNumber = null;

    /**
     * @var int $LinkedReceiptTillNumber
     */
    protected $LinkedReceiptTillNumber = null;

    /**
     * @var string $NoSaleReasonIdentifier
     */
    protected $NoSaleReasonIdentifier = null;

    /**
     * @var ArrayOfReceiptOperation $Operations
     */
    protected $Operations = null;

    /**
     * @var string $RecallReasonIdentifier
     */
    protected $RecallReasonIdentifier = null;

    /**
     * @var string $RecalledFromReceiptBranchIdentifier
     */
    protected $RecalledFromReceiptBranchIdentifier = null;

    /**
     * @var string $RecalledFromReceiptNumber
     */
    protected $RecalledFromReceiptNumber = null;

    /**
     * @var int $RecalledFromReceiptTillNumber
     */
    protected $RecalledFromReceiptTillNumber = null;

    /**
     * @var int $ReceiptId
     */
    protected $ReceiptId = null;

    /**
     * @var string $ReceiptNumber
     */
    protected $ReceiptNumber = null;

    /**
     * @var ReceiptStatus $ReceiptStatus
     */
    protected $ReceiptStatus = null;

    /**
     * @var TillOperationType $ReceiptType
     */
    protected $ReceiptType = null;

    /**
     * @var DateTimeOffset $ResolvedDate
     */
    protected $ResolvedDate = null;

    /**
     * @var string $SuspendReasonIdentifier
     */
    protected $SuspendReasonIdentifier = null;

    /**
     * @var ArrayOfReceiptTender $Tenders
     */
    protected $Tenders = null;

    /**
     * @var int $TillNumber
     */
    protected $TillNumber = null;

    /**
     * @var float $TotalLineSoldValue
     */
    protected $TotalLineSoldValue = null;

    /**
     * @var float $TotalLineValue
     */
    protected $TotalLineValue = null;

    /**
     * @var float $TotalSoldValue
     */
    protected $TotalSoldValue = null;

    /**
     * @var float $TotalTenders
     */
    protected $TotalTenders = null;

    /**
     * @var float $TotalValue
     */
    protected $TotalValue = null;

    /**
     * @var float $TotalVat
     */
    protected $TotalVat = null;

    /**
     * @var float $TotalVoucherPurchases
     */
    protected $TotalVoucherPurchases = null;

    /**
     * @var \DateTime $TransactionDate
     */
    protected $TransactionDate = null;

    /**
     * @var boolean $TransactionVoid
     */
    protected $TransactionVoid = null;

    /**
     * @var ArrayOfReceiptAccountTransaction $TransactionsOnAccount
     */
    protected $TransactionsOnAccount = null;

    /**
     * @var ArrayOfReceiptVoucherPurchase $VoucherPurchases
     */
    protected $VoucherPurchases = null;

    
    public function __construct()
    {
      parent::__construct();
    }

    /**
     * @return string
     */
    public function getAssistantUsername()
    {
      return $this->AssistantUsername;
    }

    /**
     * @param string $AssistantUsername
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setAssistantUsername($AssistantUsername)
    {
      $this->AssistantUsername = $AssistantUsername;
      return $this;
    }

    /**
     * @return DateTimeOffset
     */
    public function getBeginDateTime()
    {
      return $this->BeginDateTime;
    }

    /**
     * @param DateTimeOffset $BeginDateTime
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setBeginDateTime($BeginDateTime)
    {
      $this->BeginDateTime = $BeginDateTime;
      return $this;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->BranchIdentifier;
    }

    /**
     * @param string $BranchIdentifier
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setBranchIdentifier($BranchIdentifier)
    {
      $this->BranchIdentifier = $BranchIdentifier;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedDate()
    {
      if ($this->CreatedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CreatedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CreatedDate
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setCreatedDate(\DateTime $CreatedDate = null)
    {
      if ($CreatedDate == null) {
       $this->CreatedDate = null;
      } else {
        $this->CreatedDate = $CreatedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomerAccountNumber()
    {
      return $this->CustomerAccountNumber;
    }

    /**
     * @param string $CustomerAccountNumber
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setCustomerAccountNumber($CustomerAccountNumber)
    {
      $this->CustomerAccountNumber = $CustomerAccountNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomerAccountType()
    {
      return $this->CustomerAccountType;
    }

    /**
     * @param string $CustomerAccountType
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setCustomerAccountType($CustomerAccountType)
    {
      $this->CustomerAccountType = $CustomerAccountType;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomerIdentifier()
    {
      return $this->CustomerIdentifier;
    }

    /**
     * @param string $CustomerIdentifier
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setCustomerIdentifier($CustomerIdentifier)
    {
      $this->CustomerIdentifier = $CustomerIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomerOrderIdentifier()
    {
      return $this->CustomerOrderIdentifier;
    }

    /**
     * @param string $CustomerOrderIdentifier
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setCustomerOrderIdentifier($CustomerOrderIdentifier)
    {
      $this->CustomerOrderIdentifier = $CustomerOrderIdentifier;
      return $this;
    }

    /**
     * @return DateTimeOffset
     */
    public function getEndDateTime()
    {
      return $this->EndDateTime;
    }

    /**
     * @param DateTimeOffset $EndDateTime
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setEndDateTime($EndDateTime)
    {
      $this->EndDateTime = $EndDateTime;
      return $this;
    }

    /**
     * @return string
     */
    public function getExternalTransactionId()
    {
      return $this->ExternalTransactionId;
    }

    /**
     * @param string $ExternalTransactionId
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setExternalTransactionId($ExternalTransactionId)
    {
      $this->ExternalTransactionId = $ExternalTransactionId;
      return $this;
    }

    /**
     * @return ArrayOfReceiptGiftCardTransaction
     */
    public function getGiftCardTransactions()
    {
      return $this->GiftCardTransactions;
    }

    /**
     * @param ArrayOfReceiptGiftCardTransaction $GiftCardTransactions
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setGiftCardTransactions($GiftCardTransactions)
    {
      $this->GiftCardTransactions = $GiftCardTransactions;
      return $this;
    }

    /**
     * @return string
     */
    public function getGiroSlipNumber()
    {
      return $this->GiroSlipNumber;
    }

    /**
     * @param string $GiroSlipNumber
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setGiroSlipNumber($GiroSlipNumber)
    {
      $this->GiroSlipNumber = $GiroSlipNumber;
      return $this;
    }

    /**
     * @return ArrayOfReceiptLineSku
     */
    public function getLines()
    {
      return $this->Lines;
    }

    /**
     * @param ArrayOfReceiptLineSku $Lines
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setLines($Lines)
    {
      $this->Lines = $Lines;
      return $this;
    }

    /**
     * @return string
     */
    public function getLinkedReceiptBranchIdentifier()
    {
      return $this->LinkedReceiptBranchIdentifier;
    }

    /**
     * @param string $LinkedReceiptBranchIdentifier
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setLinkedReceiptBranchIdentifier($LinkedReceiptBranchIdentifier)
    {
      $this->LinkedReceiptBranchIdentifier = $LinkedReceiptBranchIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getLinkedReceiptNumber()
    {
      return $this->LinkedReceiptNumber;
    }

    /**
     * @param string $LinkedReceiptNumber
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setLinkedReceiptNumber($LinkedReceiptNumber)
    {
      $this->LinkedReceiptNumber = $LinkedReceiptNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getLinkedReceiptTillNumber()
    {
      return $this->LinkedReceiptTillNumber;
    }

    /**
     * @param int $LinkedReceiptTillNumber
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setLinkedReceiptTillNumber($LinkedReceiptTillNumber)
    {
      $this->LinkedReceiptTillNumber = $LinkedReceiptTillNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getNoSaleReasonIdentifier()
    {
      return $this->NoSaleReasonIdentifier;
    }

    /**
     * @param string $NoSaleReasonIdentifier
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setNoSaleReasonIdentifier($NoSaleReasonIdentifier)
    {
      $this->NoSaleReasonIdentifier = $NoSaleReasonIdentifier;
      return $this;
    }

    /**
     * @return ArrayOfReceiptOperation
     */
    public function getOperations()
    {
      return $this->Operations;
    }

    /**
     * @param ArrayOfReceiptOperation $Operations
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setOperations($Operations)
    {
      $this->Operations = $Operations;
      return $this;
    }

    /**
     * @return string
     */
    public function getRecallReasonIdentifier()
    {
      return $this->RecallReasonIdentifier;
    }

    /**
     * @param string $RecallReasonIdentifier
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setRecallReasonIdentifier($RecallReasonIdentifier)
    {
      $this->RecallReasonIdentifier = $RecallReasonIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getRecalledFromReceiptBranchIdentifier()
    {
      return $this->RecalledFromReceiptBranchIdentifier;
    }

    /**
     * @param string $RecalledFromReceiptBranchIdentifier
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setRecalledFromReceiptBranchIdentifier($RecalledFromReceiptBranchIdentifier)
    {
      $this->RecalledFromReceiptBranchIdentifier = $RecalledFromReceiptBranchIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getRecalledFromReceiptNumber()
    {
      return $this->RecalledFromReceiptNumber;
    }

    /**
     * @param string $RecalledFromReceiptNumber
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setRecalledFromReceiptNumber($RecalledFromReceiptNumber)
    {
      $this->RecalledFromReceiptNumber = $RecalledFromReceiptNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getRecalledFromReceiptTillNumber()
    {
      return $this->RecalledFromReceiptTillNumber;
    }

    /**
     * @param int $RecalledFromReceiptTillNumber
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setRecalledFromReceiptTillNumber($RecalledFromReceiptTillNumber)
    {
      $this->RecalledFromReceiptTillNumber = $RecalledFromReceiptTillNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getReceiptId()
    {
      return $this->ReceiptId;
    }

    /**
     * @param int $ReceiptId
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setReceiptId($ReceiptId)
    {
      $this->ReceiptId = $ReceiptId;
      return $this;
    }

    /**
     * @return string
     */
    public function getReceiptNumber()
    {
      return $this->ReceiptNumber;
    }

    /**
     * @param string $ReceiptNumber
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setReceiptNumber($ReceiptNumber)
    {
      $this->ReceiptNumber = $ReceiptNumber;
      return $this;
    }

    /**
     * @return ReceiptStatus
     */
    public function getReceiptStatus()
    {
      return $this->ReceiptStatus;
    }

    /**
     * @param ReceiptStatus $ReceiptStatus
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setReceiptStatus($ReceiptStatus)
    {
      $this->ReceiptStatus = $ReceiptStatus;
      return $this;
    }

    /**
     * @return TillOperationType
     */
    public function getReceiptType()
    {
      return $this->ReceiptType;
    }

    /**
     * @param TillOperationType $ReceiptType
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setReceiptType($ReceiptType)
    {
      $this->ReceiptType = $ReceiptType;
      return $this;
    }

    /**
     * @return DateTimeOffset
     */
    public function getResolvedDate()
    {
      return $this->ResolvedDate;
    }

    /**
     * @param DateTimeOffset $ResolvedDate
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setResolvedDate($ResolvedDate)
    {
      $this->ResolvedDate = $ResolvedDate;
      return $this;
    }

    /**
     * @return string
     */
    public function getSuspendReasonIdentifier()
    {
      return $this->SuspendReasonIdentifier;
    }

    /**
     * @param string $SuspendReasonIdentifier
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setSuspendReasonIdentifier($SuspendReasonIdentifier)
    {
      $this->SuspendReasonIdentifier = $SuspendReasonIdentifier;
      return $this;
    }

    /**
     * @return ArrayOfReceiptTender
     */
    public function getTenders()
    {
      return $this->Tenders;
    }

    /**
     * @param ArrayOfReceiptTender $Tenders
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setTenders($Tenders)
    {
      $this->Tenders = $Tenders;
      return $this;
    }

    /**
     * @return int
     */
    public function getTillNumber()
    {
      return $this->TillNumber;
    }

    /**
     * @param int $TillNumber
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setTillNumber($TillNumber)
    {
      $this->TillNumber = $TillNumber;
      return $this;
    }

    /**
     * @return float
     */
    public function getTotalLineSoldValue()
    {
      return $this->TotalLineSoldValue;
    }

    /**
     * @param float $TotalLineSoldValue
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setTotalLineSoldValue($TotalLineSoldValue)
    {
      $this->TotalLineSoldValue = $TotalLineSoldValue;
      return $this;
    }

    /**
     * @return float
     */
    public function getTotalLineValue()
    {
      return $this->TotalLineValue;
    }

    /**
     * @param float $TotalLineValue
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setTotalLineValue($TotalLineValue)
    {
      $this->TotalLineValue = $TotalLineValue;
      return $this;
    }

    /**
     * @return float
     */
    public function getTotalSoldValue()
    {
      return $this->TotalSoldValue;
    }

    /**
     * @param float $TotalSoldValue
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setTotalSoldValue($TotalSoldValue)
    {
      $this->TotalSoldValue = $TotalSoldValue;
      return $this;
    }

    /**
     * @return float
     */
    public function getTotalTenders()
    {
      return $this->TotalTenders;
    }

    /**
     * @param float $TotalTenders
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setTotalTenders($TotalTenders)
    {
      $this->TotalTenders = $TotalTenders;
      return $this;
    }

    /**
     * @return float
     */
    public function getTotalValue()
    {
      return $this->TotalValue;
    }

    /**
     * @param float $TotalValue
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setTotalValue($TotalValue)
    {
      $this->TotalValue = $TotalValue;
      return $this;
    }

    /**
     * @return float
     */
    public function getTotalVat()
    {
      return $this->TotalVat;
    }

    /**
     * @param float $TotalVat
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setTotalVat($TotalVat)
    {
      $this->TotalVat = $TotalVat;
      return $this;
    }

    /**
     * @return float
     */
    public function getTotalVoucherPurchases()
    {
      return $this->TotalVoucherPurchases;
    }

    /**
     * @param float $TotalVoucherPurchases
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setTotalVoucherPurchases($TotalVoucherPurchases)
    {
      $this->TotalVoucherPurchases = $TotalVoucherPurchases;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getTransactionDate()
    {
      if ($this->TransactionDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->TransactionDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $TransactionDate
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setTransactionDate(\DateTime $TransactionDate = null)
    {
      if ($TransactionDate == null) {
       $this->TransactionDate = null;
      } else {
        $this->TransactionDate = $TransactionDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return boolean
     */
    public function getTransactionVoid()
    {
      return $this->TransactionVoid;
    }

    /**
     * @param boolean $TransactionVoid
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setTransactionVoid($TransactionVoid)
    {
      $this->TransactionVoid = $TransactionVoid;
      return $this;
    }

    /**
     * @return ArrayOfReceiptAccountTransaction
     */
    public function getTransactionsOnAccount()
    {
      return $this->TransactionsOnAccount;
    }

    /**
     * @param ArrayOfReceiptAccountTransaction $TransactionsOnAccount
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setTransactionsOnAccount($TransactionsOnAccount)
    {
      $this->TransactionsOnAccount = $TransactionsOnAccount;
      return $this;
    }

    /**
     * @return ArrayOfReceiptVoucherPurchase
     */
    public function getVoucherPurchases()
    {
      return $this->VoucherPurchases;
    }

    /**
     * @param ArrayOfReceiptVoucherPurchase $VoucherPurchases
     * @return \Eurostop\Sales\ReceiptHeader
     */
    public function setVoucherPurchases($VoucherPurchases)
    {
      $this->VoucherPurchases = $VoucherPurchases;
      return $this;
    }

}
