<?php

namespace Eurostop\Sales;

class ReceiptGiftCardTransactionCustom extends RetrievedDataItemOfReceiptGiftCardTransactionDtonkuuQA70Custom
{

    /**
     * @var string $AuthCode
     */
    protected $AuthCode = null;

    /**
     * @var string $CurrencyIdentifier
     */
    protected $CurrencyIdentifier = null;

    /**
     * @var string $GiftCardNumber
     */
    protected $GiftCardNumber = null;

    /**
     * @var string $GiftCardVendor
     */
    protected $GiftCardVendor = null;

    /**
     * @var int $LineNumber
     */
    protected $LineNumber = null;

    /**
     * @var string $Reference
     */
    protected $Reference = null;

    /**
     * @var float $RemainingBalance
     */
    protected $RemainingBalance = null;

    /**
     * @var GiftCardTransactionType $TransactionType
     */
    protected $TransactionType = null;

    /**
     * @var string $TypeDescription
     */
    protected $TypeDescription = null;

    /**
     * @var string $TypeSubCode
     */
    protected $TypeSubCode = null;

    /**
     * @var GiftCardTransactionValidity $Validity
     */
    protected $Validity = null;

    /**
     * @var float $Value
     */
    protected $Value = null;

    /**
     * @param int $LineNumber
     * @param float $RemainingBalance
     * @param GiftCardTransactionType $TransactionType
     * @param GiftCardTransactionValidity $Validity
     * @param float $Value
     */
    public function __construct($LineNumber, $RemainingBalance, $TransactionType, $Validity, $Value)
    {
      parent::__construct();
      $this->LineNumber = $LineNumber;
      $this->RemainingBalance = $RemainingBalance;
      $this->TransactionType = $TransactionType;
      $this->Validity = $Validity;
      $this->Value = $Value;
    }

    /**
     * @return string
     */
    public function getAuthCode()
    {
      return $this->AuthCode;
    }

    /**
     * @param string $AuthCode
     * @return \Eurostop\Sales\ReceiptGiftCardTransaction
     */
    public function setAuthCode($AuthCode)
    {
      $this->AuthCode = $AuthCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getCurrencyIdentifier()
    {
      return $this->CurrencyIdentifier;
    }

    /**
     * @param string $CurrencyIdentifier
     * @return \Eurostop\Sales\ReceiptGiftCardTransaction
     */
    public function setCurrencyIdentifier($CurrencyIdentifier)
    {
      $this->CurrencyIdentifier = $CurrencyIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getGiftCardNumber()
    {
      return $this->GiftCardNumber;
    }

    /**
     * @param string $GiftCardNumber
     * @return \Eurostop\Sales\ReceiptGiftCardTransaction
     */
    public function setGiftCardNumber($GiftCardNumber)
    {
      $this->GiftCardNumber = $GiftCardNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getGiftCardVendor()
    {
      return $this->GiftCardVendor;
    }

    /**
     * @param string $GiftCardVendor
     * @return \Eurostop\Sales\ReceiptGiftCardTransaction
     */
    public function setGiftCardVendor($GiftCardVendor)
    {
      $this->GiftCardVendor = $GiftCardVendor;
      return $this;
    }

    /**
     * @return int
     */
    public function getLineNumber()
    {
      return $this->LineNumber;
    }

    /**
     * @param int $LineNumber
     * @return \Eurostop\Sales\ReceiptGiftCardTransaction
     */
    public function setLineNumber($LineNumber)
    {
      $this->LineNumber = $LineNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getReference()
    {
      return $this->Reference;
    }

    /**
     * @param string $Reference
     * @return \Eurostop\Sales\ReceiptGiftCardTransaction
     */
    public function setReference($Reference)
    {
      $this->Reference = $Reference;
      return $this;
    }

    /**
     * @return float
     */
    public function getRemainingBalance()
    {
      return $this->RemainingBalance;
    }

    /**
     * @param float $RemainingBalance
     * @return \Eurostop\Sales\ReceiptGiftCardTransaction
     */
    public function setRemainingBalance($RemainingBalance)
    {
      $this->RemainingBalance = $RemainingBalance;
      return $this;
    }

    /**
     * @return GiftCardTransactionType
     */
    public function getTransactionType()
    {
      return $this->TransactionType;
    }

    /**
     * @param GiftCardTransactionType $TransactionType
     * @return \Eurostop\Sales\ReceiptGiftCardTransaction
     */
    public function setTransactionType($TransactionType)
    {
      $this->TransactionType = $TransactionType;
      return $this;
    }

    /**
     * @return string
     */
    public function getTypeDescription()
    {
      return $this->TypeDescription;
    }

    /**
     * @param string $TypeDescription
     * @return \Eurostop\Sales\ReceiptGiftCardTransaction
     */
    public function setTypeDescription($TypeDescription)
    {
      $this->TypeDescription = $TypeDescription;
      return $this;
    }

    /**
     * @return string
     */
    public function getTypeSubCode()
    {
      return $this->TypeSubCode;
    }

    /**
     * @param string $TypeSubCode
     * @return \Eurostop\Sales\ReceiptGiftCardTransaction
     */
    public function setTypeSubCode($TypeSubCode)
    {
      $this->TypeSubCode = $TypeSubCode;
      return $this;
    }

    /**
     * @return GiftCardTransactionValidity
     */
    public function getValidity()
    {
      return $this->Validity;
    }

    /**
     * @param GiftCardTransactionValidity $Validity
     * @return \Eurostop\Sales\ReceiptGiftCardTransaction
     */
    public function setValidity($Validity)
    {
      $this->Validity = $Validity;
      return $this;
    }

    /**
     * @return float
     */
    public function getValue()
    {
      return $this->Value;
    }

    /**
     * @param float $Value
     * @return \Eurostop\Sales\ReceiptGiftCardTransaction
     */
    public function setValue($Value)
    {
      $this->Value = $Value;
      return $this;
    }

}
