<?php

namespace Eurostop\Sales;

class ReceiptAccountTransactionCustom extends RetrievedDataItemOfReceiptAccountTransactionDtonkuuQA70Custom
{

    /**
     * @var string $CustomerAccountNumber
     */
    protected $CustomerAccountNumber = null;

    /**
     * @var string $CustomerAccountType
     */
    protected $CustomerAccountType = null;

    /**
     * @var string $CustomerIdentifier
     */
    protected $CustomerIdentifier = null;

    /**
     * @var \DateTime $TransactionDate
     */
    protected $TransactionDate = null;

    /**
     * @var AccountTransactionClass $TypeClass
     */
    protected $TypeClass = null;

    /**
     * @var string $TypeCode
     */
    protected $TypeCode = null;

    /**
     * @var string $TypeDescription
     */
    protected $TypeDescription = null;

    /**
     * @var string $TypeSubCode
     */
    protected $TypeSubCode = null;

    /**
     * @var float $Value
     */
    protected $Value = null;

    /**
     * @param \DateTime $TransactionDate
     * @param AccountTransactionClass $TypeClass
     * @param float $Value
     */
    public function __construct(\DateTime $TransactionDate, $TypeClass, $Value)
    {
      parent::__construct();
      $this->TransactionDate = $TransactionDate->format(\DateTime::ATOM);
      $this->TypeClass = $TypeClass;
      $this->Value = $Value;
    }

    /**
     * @return string
     */
    public function getCustomerAccountNumber()
    {
      return $this->CustomerAccountNumber;
    }

    /**
     * @param string $CustomerAccountNumber
     * @return \Eurostop\Sales\ReceiptAccountTransaction
     */
    public function setCustomerAccountNumber($CustomerAccountNumber)
    {
      $this->CustomerAccountNumber = $CustomerAccountNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomerAccountType()
    {
      return $this->CustomerAccountType;
    }

    /**
     * @param string $CustomerAccountType
     * @return \Eurostop\Sales\ReceiptAccountTransaction
     */
    public function setCustomerAccountType($CustomerAccountType)
    {
      $this->CustomerAccountType = $CustomerAccountType;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomerIdentifier()
    {
      return $this->CustomerIdentifier;
    }

    /**
     * @param string $CustomerIdentifier
     * @return \Eurostop\Sales\ReceiptAccountTransaction
     */
    public function setCustomerIdentifier($CustomerIdentifier)
    {
      $this->CustomerIdentifier = $CustomerIdentifier;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getTransactionDate()
    {
      if ($this->TransactionDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->TransactionDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $TransactionDate
     * @return \Eurostop\Sales\ReceiptAccountTransaction
     */
    public function setTransactionDate(\DateTime $TransactionDate)
    {
      $this->TransactionDate = $TransactionDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return AccountTransactionClass
     */
    public function getTypeClass()
    {
      return $this->TypeClass;
    }

    /**
     * @param AccountTransactionClass $TypeClass
     * @return \Eurostop\Sales\ReceiptAccountTransaction
     */
    public function setTypeClass($TypeClass)
    {
      $this->TypeClass = $TypeClass;
      return $this;
    }

    /**
     * @return string
     */
    public function getTypeCode()
    {
      return $this->TypeCode;
    }

    /**
     * @param string $TypeCode
     * @return \Eurostop\Sales\ReceiptAccountTransaction
     */
    public function setTypeCode($TypeCode)
    {
      $this->TypeCode = $TypeCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getTypeDescription()
    {
      return $this->TypeDescription;
    }

    /**
     * @param string $TypeDescription
     * @return \Eurostop\Sales\ReceiptAccountTransaction
     */
    public function setTypeDescription($TypeDescription)
    {
      $this->TypeDescription = $TypeDescription;
      return $this;
    }

    /**
     * @return string
     */
    public function getTypeSubCode()
    {
      return $this->TypeSubCode;
    }

    /**
     * @param string $TypeSubCode
     * @return \Eurostop\Sales\ReceiptAccountTransaction
     */
    public function setTypeSubCode($TypeSubCode)
    {
      $this->TypeSubCode = $TypeSubCode;
      return $this;
    }

    /**
     * @return float
     */
    public function getValue()
    {
      return $this->Value;
    }

    /**
     * @param float $Value
     * @return \Eurostop\Sales\ReceiptAccountTransaction
     */
    public function setValue($Value)
    {
      $this->Value = $Value;
      return $this;
    }

}
