<?php

namespace Eurostop\Sales;

class GetReceiptsByTransactionDateCustom
{

    /**
     * @var \DateTime $fromDate
     */
    protected $fromDate = null;

    /**
     * @var \DateTime $toDate
     */
    protected $toDate = null;

    /**
     * @var int $maxReceipts
     */
    protected $maxReceipts = null;

    /**
     * @param \DateTime $fromDate
     * @param \DateTime $toDate
     * @param int $maxReceipts
     */
    public function __construct(\DateTime $fromDate, \DateTime $toDate, $maxReceipts)
    {
      $this->fromDate = $fromDate->format(\DateTime::ATOM);
      $this->toDate = $toDate->format(\DateTime::ATOM);
      $this->maxReceipts = $maxReceipts;
    }

    /**
     * @return \DateTime
     */
    public function getFromDate()
    {
      if ($this->fromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->fromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $fromDate
     * @return \Eurostop\Sales\GetReceiptsByTransactionDate
     */
    public function setFromDate(\DateTime $fromDate)
    {
      $this->fromDate = $fromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getToDate()
    {
      if ($this->toDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->toDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $toDate
     * @return \Eurostop\Sales\GetReceiptsByTransactionDate
     */
    public function setToDate(\DateTime $toDate)
    {
      $this->toDate = $toDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return int
     */
    public function getMaxReceipts()
    {
      return $this->maxReceipts;
    }

    /**
     * @param int $maxReceipts
     * @return \Eurostop\Sales\GetReceiptsByTransactionDate
     */
    public function setMaxReceipts($maxReceipts)
    {
      $this->maxReceipts = $maxReceipts;
      return $this;
    }

}
