<?php

namespace Eurostop\Sales;

class GetReceiptsByReceiptIdentifierCustom
{

    /**
     * @var string $branchIdentifier
     */
    protected $branchIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var int $tillNumber
     */
    protected $tillNumber = null;

    /**
     * @var string $fromReceiptIdentifier
     */
    protected $fromReceiptIdentifier = null;

    /**
     * @var string $toReceiptIdentifier
     */
    protected $toReceiptIdentifier = null;

    /**
     * @var ReceiptIdentifierType $receiptIdentifierType
     */
    protected $receiptIdentifierType = null;

    /**
     * @var int $maxReceipts
     */
    protected $maxReceipts = null;

    /**
     * @param string $branchIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param int $tillNumber
     * @param string $fromReceiptIdentifier
     * @param string $toReceiptIdentifier
     * @param ReceiptIdentifierType $receiptIdentifierType
     * @param int $maxReceipts
     */
    public function __construct($branchIdentifier, $branchIdentifierType, $tillNumber, $fromReceiptIdentifier, $toReceiptIdentifier, $receiptIdentifierType, $maxReceipts)
    {
      $this->branchIdentifier = $branchIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->tillNumber = $tillNumber;
      $this->fromReceiptIdentifier = $fromReceiptIdentifier;
      $this->toReceiptIdentifier = $toReceiptIdentifier;
      $this->receiptIdentifierType = $receiptIdentifierType;
      $this->maxReceipts = $maxReceipts;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->branchIdentifier;
    }

    /**
     * @param string $branchIdentifier
     * @return \Eurostop\Sales\GetReceiptsByReceiptIdentifier
     */
    public function setBranchIdentifier($branchIdentifier)
    {
      $this->branchIdentifier = $branchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Sales\GetReceiptsByReceiptIdentifier
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return int
     */
    public function getTillNumber()
    {
      return $this->tillNumber;
    }

    /**
     * @param int $tillNumber
     * @return \Eurostop\Sales\GetReceiptsByReceiptIdentifier
     */
    public function setTillNumber($tillNumber)
    {
      $this->tillNumber = $tillNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getFromReceiptIdentifier()
    {
      return $this->fromReceiptIdentifier;
    }

    /**
     * @param string $fromReceiptIdentifier
     * @return \Eurostop\Sales\GetReceiptsByReceiptIdentifier
     */
    public function setFromReceiptIdentifier($fromReceiptIdentifier)
    {
      $this->fromReceiptIdentifier = $fromReceiptIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getToReceiptIdentifier()
    {
      return $this->toReceiptIdentifier;
    }

    /**
     * @param string $toReceiptIdentifier
     * @return \Eurostop\Sales\GetReceiptsByReceiptIdentifier
     */
    public function setToReceiptIdentifier($toReceiptIdentifier)
    {
      $this->toReceiptIdentifier = $toReceiptIdentifier;
      return $this;
    }

    /**
     * @return ReceiptIdentifierType
     */
    public function getReceiptIdentifierType()
    {
      return $this->receiptIdentifierType;
    }

    /**
     * @param ReceiptIdentifierType $receiptIdentifierType
     * @return \Eurostop\Sales\GetReceiptsByReceiptIdentifier
     */
    public function setReceiptIdentifierType($receiptIdentifierType)
    {
      $this->receiptIdentifierType = $receiptIdentifierType;
      return $this;
    }

    /**
     * @return int
     */
    public function getMaxReceipts()
    {
      return $this->maxReceipts;
    }

    /**
     * @param int $maxReceipts
     * @return \Eurostop\Sales\GetReceiptsByReceiptIdentifier
     */
    public function setMaxReceipts($maxReceipts)
    {
      $this->maxReceipts = $maxReceipts;
      return $this;
    }

}
