<?php

namespace Eurostop\Products;

class SubmittedSkuPrice extends SubmittedDataItemOfSubmittedSkuPriceDtoVNxenGD6
{

    /**
     * @var string $CountryIdentifier
     */
    protected $CountryIdentifier = null;

    /**
     * @var CountryIdentifierType $CountryIdentifierType
     */
    protected $CountryIdentifierType = null;

    /**
     * @var float $CurrentSellingPrice
     */
    protected $CurrentSellingPrice = null;

    /**
     * @var \DateTime $EffectiveDate
     */
    protected $EffectiveDate = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var SkuIdentifierType $SkuIdentifierType
     */
    protected $SkuIdentifierType = null;

    
    public function __construct()
    {
      parent::__construct();
    }

    /**
     * @return string
     */
    public function getCountryIdentifier()
    {
      return $this->CountryIdentifier;
    }

    /**
     * @param string $CountryIdentifier
     * @return \Eurostop\Products\SubmittedSkuPrice
     */
    public function setCountryIdentifier($CountryIdentifier)
    {
      $this->CountryIdentifier = $CountryIdentifier;
      return $this;
    }

    /**
     * @return CountryIdentifierType
     */
    public function getCountryIdentifierType()
    {
      return $this->CountryIdentifierType;
    }

    /**
     * @param CountryIdentifierType $CountryIdentifierType
     * @return \Eurostop\Products\SubmittedSkuPrice
     */
    public function setCountryIdentifierType($CountryIdentifierType)
    {
      $this->CountryIdentifierType = $CountryIdentifierType;
      return $this;
    }

    /**
     * @return float
     */
    public function getCurrentSellingPrice()
    {
      return $this->CurrentSellingPrice;
    }

    /**
     * @param float $CurrentSellingPrice
     * @return \Eurostop\Products\SubmittedSkuPrice
     */
    public function setCurrentSellingPrice($CurrentSellingPrice)
    {
      $this->CurrentSellingPrice = $CurrentSellingPrice;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEffectiveDate()
    {
      if ($this->EffectiveDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->EffectiveDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $EffectiveDate
     * @return \Eurostop\Products\SubmittedSkuPrice
     */
    public function setEffectiveDate(\DateTime $EffectiveDate = null)
    {
      if ($EffectiveDate == null) {
       $this->EffectiveDate = null;
      } else {
        $this->EffectiveDate = $EffectiveDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Products\SubmittedSkuPrice
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return SkuIdentifierType
     */
    public function getSkuIdentifierType()
    {
      return $this->SkuIdentifierType;
    }

    /**
     * @param SkuIdentifierType $SkuIdentifierType
     * @return \Eurostop\Products\SubmittedSkuPrice
     */
    public function setSkuIdentifierType($SkuIdentifierType)
    {
      $this->SkuIdentifierType = $SkuIdentifierType;
      return $this;
    }

}
