<?php

namespace Eurostop\Products;

class SubmitSuppliersCustom
{

    /**
     * @var ArrayOfSubmittedSupplier $suppliers
     */
    protected $suppliers = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedSupplier $suppliers
     * @param string $submissionReference
     */
    public function __construct($suppliers, $submissionReference)
    {
      $this->suppliers = $suppliers;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedSupplier
     */
    public function getSuppliers()
    {
      return $this->suppliers;
    }

    /**
     * @param ArrayOfSubmittedSupplier $suppliers
     * @return \Eurostop\Products\SubmitSuppliers
     */
    public function setSuppliers($suppliers)
    {
      $this->suppliers = $suppliers;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitSuppliers
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
