<?php

namespace Eurostop\Products;

class SubmitSupplier
{

    /**
     * @var SubmittedSupplier $supplier
     */
    protected $supplier = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedSupplier $supplier
     * @param string $submissionReference
     */
    public function __construct($supplier = null, $submissionReference = null)
    {
      $this->supplier = $supplier;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedSupplier
     */
    public function getSupplier()
    {
      return $this->supplier;
    }

    /**
     * @param SubmittedSupplier $supplier
     * @return \Eurostop\Products\SubmitSupplier
     */
    public function setSupplier($supplier)
    {
      $this->supplier = $supplier;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitSupplier
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
