<?php

namespace Eurostop\Products;

class SubmitSkuPricesCustom
{

    /**
     * @var ArrayOfSubmittedSkuPrice $skuPrices
     */
    protected $skuPrices = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedSkuPrice $skuPrices
     * @param string $submissionReference
     */
    public function __construct($skuPrices, $submissionReference)
    {
      $this->skuPrices = $skuPrices;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedSkuPrice
     */
    public function getSkuPrices()
    {
      return $this->skuPrices;
    }

    /**
     * @param ArrayOfSubmittedSkuPrice $skuPrices
     * @return \Eurostop\Products\SubmitSkuPrices
     */
    public function setSkuPrices($skuPrices)
    {
      $this->skuPrices = $skuPrices;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitSkuPrices
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
