<?php

namespace Eurostop\Products;

class SubmitSkuPriceCustom
{

    /**
     * @var SubmittedSkuPrice $skuPrice
     */
    protected $skuPrice = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedSkuPrice $skuPrice
     * @param string $submissionReference
     */
    public function __construct($skuPrice, $submissionReference)
    {
      $this->skuPrice = $skuPrice;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedSkuPrice
     */
    public function getSkuPrice()
    {
      return $this->skuPrice;
    }

    /**
     * @param SubmittedSkuPrice $skuPrice
     * @return \Eurostop\Products\SubmitSkuPrice
     */
    public function setSkuPrice($skuPrice)
    {
      $this->skuPrice = $skuPrice;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitSkuPrice
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
