<?php

namespace Eurostop\Products;

class SubmitSizeGroupCustom
{

    /**
     * @var SubmittedSizeGroup $sizeGroup
     */
    protected $sizeGroup = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedSizeGroup $sizeGroup
     * @param string $submissionReference
     */
    public function __construct($sizeGroup, $submissionReference)
    {
      $this->sizeGroup = $sizeGroup;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedSizeGroup
     */
    public function getSizeGroup()
    {
      return $this->sizeGroup;
    }

    /**
     * @param SubmittedSizeGroup $sizeGroup
     * @return \Eurostop\Products\SubmitSizeGroup
     */
    public function setSizeGroup($sizeGroup)
    {
      $this->sizeGroup = $sizeGroup;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitSizeGroup
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
