<?php

namespace Eurostop\Products;

class SubmitSize
{

    /**
     * @var SubmittedSize $size
     */
    protected $size = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedSize $size
     * @param string $submissionReference
     */
    public function __construct($size = null, $submissionReference = null)
    {
      $this->size = $size;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedSize
     */
    public function getSize()
    {
      return $this->size;
    }

    /**
     * @param SubmittedSize $size
     * @return \Eurostop\Products\SubmitSize
     */
    public function setSize($size)
    {
      $this->size = $size;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitSize
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
