<?php

namespace Eurostop\Products;

class SubmitProductSku
{

    /**
     * @var SubmittedProductSku $productSku
     */
    protected $productSku = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedProductSku $productSku
     * @param string $submissionReference
     */
    public function __construct($productSku = null, $submissionReference = null)
    {
      $this->productSku = $productSku;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedProductSku
     */
    public function getProductSku()
    {
      return $this->productSku;
    }

    /**
     * @param SubmittedProductSku $productSku
     * @return \Eurostop\Products\SubmitProductSku
     */
    public function setProductSku($productSku)
    {
      $this->productSku = $productSku;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitProductSku
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
