<?php

namespace Eurostop\Products;

class SubmitHierarchyNodes
{

    /**
     * @var ArrayOfSubmittedHierarchyNode $hierarchyNodes
     */
    protected $hierarchyNodes = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedHierarchyNode $hierarchyNodes
     * @param string $submissionReference
     */
    public function __construct($hierarchyNodes = null, $submissionReference = null)
    {
      $this->hierarchyNodes = $hierarchyNodes;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedHierarchyNode
     */
    public function getHierarchyNodes()
    {
      return $this->hierarchyNodes;
    }

    /**
     * @param ArrayOfSubmittedHierarchyNode $hierarchyNodes
     * @return \Eurostop\Products\SubmitHierarchyNodes
     */
    public function setHierarchyNodes($hierarchyNodes)
    {
      $this->hierarchyNodes = $hierarchyNodes;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitHierarchyNodes
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
