<?php

namespace Eurostop\Products;

class SubmitHierarchyNodeCustom
{

    /**
     * @var SubmittedHierarchyNode $hierarchyNode
     */
    protected $hierarchyNode = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedHierarchyNode $hierarchyNode
     * @param string $submissionReference
     */
    public function __construct($hierarchyNode, $submissionReference)
    {
      $this->hierarchyNode = $hierarchyNode;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedHierarchyNode
     */
    public function getHierarchyNode()
    {
      return $this->hierarchyNode;
    }

    /**
     * @param SubmittedHierarchyNode $hierarchyNode
     * @return \Eurostop\Products\SubmitHierarchyNode
     */
    public function setHierarchyNode($hierarchyNode)
    {
      $this->hierarchyNode = $hierarchyNode;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitHierarchyNode
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
