<?php

namespace Eurostop\Products;

class SubmitHierarchyNodeAction
{

    /**
     * @var SubmittedHierarchyNodeAction $hierarchyNodeAction
     */
    protected $hierarchyNodeAction = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedHierarchyNodeAction $hierarchyNodeAction
     * @param string $submissionReference
     */
    public function __construct($hierarchyNodeAction, $submissionReference)
    {
      $this->hierarchyNodeAction = $hierarchyNodeAction;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedHierarchyNodeAction
     */
    public function getHierarchyNodeAction()
    {
      return $this->hierarchyNodeAction;
    }

    /**
     * @param SubmittedHierarchyNodeAction $hierarchyNodeAction
     * @return \Eurostop\Products\SubmitHierarchyNodeAction
     */
    public function setHierarchyNodeAction($hierarchyNodeAction)
    {
      $this->hierarchyNodeAction = $hierarchyNodeAction;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitHierarchyNodeAction
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
