<?php

namespace Eurostop\Products;

class SubmitBranchSkuTax
{

    /**
     * @var SubmittedBranchSkuTax $branchSkuTax
     */
    protected $branchSkuTax = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedBranchSkuTax $branchSkuTax
     * @param string $submissionReference
     */
    public function __construct($branchSkuTax = null, $submissionReference = null)
    {
      $this->branchSkuTax = $branchSkuTax;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedBranchSkuTax
     */
    public function getBranchSkuTax()
    {
      return $this->branchSkuTax;
    }

    /**
     * @param SubmittedBranchSkuTax $branchSkuTax
     * @return \Eurostop\Products\SubmitBranchSkuTax
     */
    public function setBranchSkuTax($branchSkuTax)
    {
      $this->branchSkuTax = $branchSkuTax;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitBranchSkuTax
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
