<?php

namespace Eurostop\Products;

class SubmitAnalysisValuesCustom
{

    /**
     * @var ArrayOfSubmittedAnalysisValue $analysisValues
     */
    protected $analysisValues = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedAnalysisValue $analysisValues
     * @param string $submissionReference
     */
    public function __construct($analysisValues, $submissionReference)
    {
      $this->analysisValues = $analysisValues;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedAnalysisValue
     */
    public function getAnalysisValues()
    {
      return $this->analysisValues;
    }

    /**
     * @param ArrayOfSubmittedAnalysisValue $analysisValues
     * @return \Eurostop\Products\SubmitAnalysisValues
     */
    public function setAnalysisValues($analysisValues)
    {
      $this->analysisValues = $analysisValues;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitAnalysisValues
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
