<?php

namespace Eurostop\Products;

class SubmitAnalysisValueCustom
{

    /**
     * @var SubmittedAnalysisValue $analysisValue
     */
    protected $analysisValue = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedAnalysisValue $analysisValue
     * @param string $submissionReference
     */
    public function __construct($analysisValue, $submissionReference)
    {
      $this->analysisValue = $analysisValue;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedAnalysisValue
     */
    public function getAnalysisValue()
    {
      return $this->analysisValue;
    }

    /**
     * @param SubmittedAnalysisValue $analysisValue
     * @return \Eurostop\Products\SubmitAnalysisValue
     */
    public function setAnalysisValue($analysisValue)
    {
      $this->analysisValue = $analysisValue;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitAnalysisValue
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
