<?php

namespace Eurostop\Products;

class ProductCustom extends CodedRetrievedDataItemOfProductDtoVNxenGD6Custom
{

    /**
     * @var string $AltCode1
     */
    protected $AltCode1 = null;

    /**
     * @var string $AltCode2
     */
    protected $AltCode2 = null;

    /**
     * @var ArrayOfAnalysisValue $AnalysisValues
     */
    protected $AnalysisValues = null;

    /**
     * @var AvailabilityType $Availability
     */
    protected $Availability = null;

    /**
     * @var \DateTime $CreatedDate
     */
    protected $CreatedDate = null;

    /**
     * @var string $CurrentHierarchyLevel1Identifier
     */
    protected $CurrentHierarchyLevel1Identifier = null;

    /**
     * @var string $CurrentHierarchyLevel2Identifier
     */
    protected $CurrentHierarchyLevel2Identifier = null;

    /**
     * @var string $CurrentHierarchyLevel3Identifier
     */
    protected $CurrentHierarchyLevel3Identifier = null;

    /**
     * @var string $CurrentHierarchyLevel4Identifier
     */
    protected $CurrentHierarchyLevel4Identifier = null;

    /**
     * @var string $Description
     */
    protected $Description = null;

    /**
     * @var ArrayOfExtendedAttributeValue $ExtendedAttributeValues
     */
    protected $ExtendedAttributeValues = null;

    /**
     * @var \DateTime $ModifiedDate
     */
    protected $ModifiedDate = null;

    /**
     * @var string $OriginalHierarchyLevel1Identifier
     */
    protected $OriginalHierarchyLevel1Identifier = null;

    /**
     * @var string $OriginalHierarchyLevel2Identifier
     */
    protected $OriginalHierarchyLevel2Identifier = null;

    /**
     * @var string $OriginalHierarchyLevel3Identifier
     */
    protected $OriginalHierarchyLevel3Identifier = null;

    /**
     * @var string $OriginalHierarchyLevel4Identifier
     */
    protected $OriginalHierarchyLevel4Identifier = null;

    /**
     * @var string $ShortDescription
     */
    protected $ShortDescription = null;

    /**
     * @var string $SizeGroupIdentifier
     */
    protected $SizeGroupIdentifier = null;

    /**
     * @var ArrayOfSku $Skus
     */
    protected $Skus = null;

    /**
     * @var string $SupplierIdentifier
     */
    protected $SupplierIdentifier = null;

    /**
     * @var string $SupplierProductCode
     */
    protected $SupplierProductCode = null;

    /**
     * @param AvailabilityType $Availability
     * @param \DateTime $CreatedDate
     * @param \DateTime $ModifiedDate
     */
    public function __construct($Availability, \DateTime $CreatedDate, \DateTime $ModifiedDate)
    {
      parent::__construct();
      $this->Availability = $Availability;
      $this->CreatedDate = $CreatedDate->format(\DateTime::ATOM);
      $this->ModifiedDate = $ModifiedDate->format(\DateTime::ATOM);
    }

    /**
     * @return string
     */
    public function getAltCode1()
    {
      return $this->AltCode1;
    }

    /**
     * @param string $AltCode1
     * @return \Eurostop\Products\Product
     */
    public function setAltCode1($AltCode1)
    {
      $this->AltCode1 = $AltCode1;
      return $this;
    }

    /**
     * @return string
     */
    public function getAltCode2()
    {
      return $this->AltCode2;
    }

    /**
     * @param string $AltCode2
     * @return \Eurostop\Products\Product
     */
    public function setAltCode2($AltCode2)
    {
      $this->AltCode2 = $AltCode2;
      return $this;
    }

    /**
     * @return ArrayOfAnalysisValue
     */
    public function getAnalysisValues()
    {
      return $this->AnalysisValues;
    }

    /**
     * @param ArrayOfAnalysisValue $AnalysisValues
     * @return \Eurostop\Products\Product
     */
    public function setAnalysisValues($AnalysisValues)
    {
      $this->AnalysisValues = $AnalysisValues;
      return $this;
    }

    /**
     * @return AvailabilityType
     */
    public function getAvailability()
    {
      return $this->Availability;
    }

    /**
     * @param AvailabilityType $Availability
     * @return \Eurostop\Products\Product
     */
    public function setAvailability($Availability)
    {
      $this->Availability = $Availability;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedDate()
    {
      if ($this->CreatedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CreatedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CreatedDate
     * @return \Eurostop\Products\Product
     */
    public function setCreatedDate(\DateTime $CreatedDate)
    {
      $this->CreatedDate = $CreatedDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return string
     */
    public function getCurrentHierarchyLevel1Identifier()
    {
      return $this->CurrentHierarchyLevel1Identifier;
    }

    /**
     * @param string $CurrentHierarchyLevel1Identifier
     * @return \Eurostop\Products\Product
     */
    public function setCurrentHierarchyLevel1Identifier($CurrentHierarchyLevel1Identifier)
    {
      $this->CurrentHierarchyLevel1Identifier = $CurrentHierarchyLevel1Identifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getCurrentHierarchyLevel2Identifier()
    {
      return $this->CurrentHierarchyLevel2Identifier;
    }

    /**
     * @param string $CurrentHierarchyLevel2Identifier
     * @return \Eurostop\Products\Product
     */
    public function setCurrentHierarchyLevel2Identifier($CurrentHierarchyLevel2Identifier)
    {
      $this->CurrentHierarchyLevel2Identifier = $CurrentHierarchyLevel2Identifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getCurrentHierarchyLevel3Identifier()
    {
      return $this->CurrentHierarchyLevel3Identifier;
    }

    /**
     * @param string $CurrentHierarchyLevel3Identifier
     * @return \Eurostop\Products\Product
     */
    public function setCurrentHierarchyLevel3Identifier($CurrentHierarchyLevel3Identifier)
    {
      $this->CurrentHierarchyLevel3Identifier = $CurrentHierarchyLevel3Identifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getCurrentHierarchyLevel4Identifier()
    {
      return $this->CurrentHierarchyLevel4Identifier;
    }

    /**
     * @param string $CurrentHierarchyLevel4Identifier
     * @return \Eurostop\Products\Product
     */
    public function setCurrentHierarchyLevel4Identifier($CurrentHierarchyLevel4Identifier)
    {
      $this->CurrentHierarchyLevel4Identifier = $CurrentHierarchyLevel4Identifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
      return $this->Description;
    }

    /**
     * @param string $Description
     * @return \Eurostop\Products\Product
     */
    public function setDescription($Description)
    {
      $this->Description = $Description;
      return $this;
    }

    /**
     * @return ArrayOfExtendedAttributeValue
     */
    public function getExtendedAttributeValues()
    {
      return $this->ExtendedAttributeValues;
    }

    /**
     * @param ArrayOfExtendedAttributeValue $ExtendedAttributeValues
     * @return \Eurostop\Products\Product
     */
    public function setExtendedAttributeValues($ExtendedAttributeValues)
    {
      $this->ExtendedAttributeValues = $ExtendedAttributeValues;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedDate()
    {
      if ($this->ModifiedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ModifiedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ModifiedDate
     * @return \Eurostop\Products\Product
     */
    public function setModifiedDate(\DateTime $ModifiedDate)
    {
      $this->ModifiedDate = $ModifiedDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return string
     */
    public function getOriginalHierarchyLevel1Identifier()
    {
      return $this->OriginalHierarchyLevel1Identifier;
    }

    /**
     * @param string $OriginalHierarchyLevel1Identifier
     * @return \Eurostop\Products\Product
     */
    public function setOriginalHierarchyLevel1Identifier($OriginalHierarchyLevel1Identifier)
    {
      $this->OriginalHierarchyLevel1Identifier = $OriginalHierarchyLevel1Identifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getOriginalHierarchyLevel2Identifier()
    {
      return $this->OriginalHierarchyLevel2Identifier;
    }

    /**
     * @param string $OriginalHierarchyLevel2Identifier
     * @return \Eurostop\Products\Product
     */
    public function setOriginalHierarchyLevel2Identifier($OriginalHierarchyLevel2Identifier)
    {
      $this->OriginalHierarchyLevel2Identifier = $OriginalHierarchyLevel2Identifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getOriginalHierarchyLevel3Identifier()
    {
      return $this->OriginalHierarchyLevel3Identifier;
    }

    /**
     * @param string $OriginalHierarchyLevel3Identifier
     * @return \Eurostop\Products\Product
     */
    public function setOriginalHierarchyLevel3Identifier($OriginalHierarchyLevel3Identifier)
    {
      $this->OriginalHierarchyLevel3Identifier = $OriginalHierarchyLevel3Identifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getOriginalHierarchyLevel4Identifier()
    {
      return $this->OriginalHierarchyLevel4Identifier;
    }

    /**
     * @param string $OriginalHierarchyLevel4Identifier
     * @return \Eurostop\Products\Product
     */
    public function setOriginalHierarchyLevel4Identifier($OriginalHierarchyLevel4Identifier)
    {
      $this->OriginalHierarchyLevel4Identifier = $OriginalHierarchyLevel4Identifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getShortDescription()
    {
      return $this->ShortDescription;
    }

    /**
     * @param string $ShortDescription
     * @return \Eurostop\Products\Product
     */
    public function setShortDescription($ShortDescription)
    {
      $this->ShortDescription = $ShortDescription;
      return $this;
    }

    /**
     * @return string
     */
    public function getSizeGroupIdentifier()
    {
      return $this->SizeGroupIdentifier;
    }

    /**
     * @param string $SizeGroupIdentifier
     * @return \Eurostop\Products\Product
     */
    public function setSizeGroupIdentifier($SizeGroupIdentifier)
    {
      $this->SizeGroupIdentifier = $SizeGroupIdentifier;
      return $this;
    }

    /**
     * @return ArrayOfSku
     */
    public function getSkus()
    {
      return $this->Skus;
    }

    /**
     * @param ArrayOfSku $Skus
     * @return \Eurostop\Products\Product
     */
    public function setSkus($Skus)
    {
      $this->Skus = $Skus;
      return $this;
    }

    /**
     * @return string
     */
    public function getSupplierIdentifier()
    {
      return $this->SupplierIdentifier;
    }

    /**
     * @param string $SupplierIdentifier
     * @return \Eurostop\Products\Product
     */
    public function setSupplierIdentifier($SupplierIdentifier)
    {
      $this->SupplierIdentifier = $SupplierIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getSupplierProductCode()
    {
      return $this->SupplierProductCode;
    }

    /**
     * @param string $SupplierProductCode
     * @return \Eurostop\Products\Product
     */
    public function setSupplierProductCode($SupplierProductCode)
    {
      $this->SupplierProductCode = $SupplierProductCode;
      return $this;
    }

}
