<?php

namespace Eurostop\Products;

class GetSkuPriceByCountryAndSkuCustom
{

    /**
     * @var string $countryIdentifier
     */
    protected $countryIdentifier = null;

    /**
     * @var CountryIdentifierType $countryIdentifierType
     */
    protected $countryIdentifierType = null;

    /**
     * @var string $skuIdentifier
     */
    protected $skuIdentifier = null;

    /**
     * @var SkuIdentifierType $skuIdentifierType
     */
    protected $skuIdentifierType = null;

    /**
     * @param string $countryIdentifier
     * @param CountryIdentifierType $countryIdentifierType
     * @param string $skuIdentifier
     * @param SkuIdentifierType $skuIdentifierType
     */
    public function __construct($countryIdentifier, $countryIdentifierType, $skuIdentifier, $skuIdentifierType)
    {
      $this->countryIdentifier = $countryIdentifier;
      $this->countryIdentifierType = $countryIdentifierType;
      $this->skuIdentifier = $skuIdentifier;
      $this->skuIdentifierType = $skuIdentifierType;
    }

    /**
     * @return string
     */
    public function getCountryIdentifier()
    {
      return $this->countryIdentifier;
    }

    /**
     * @param string $countryIdentifier
     * @return \Eurostop\Products\GetSkuPriceByCountryAndSku
     */
    public function setCountryIdentifier($countryIdentifier)
    {
      $this->countryIdentifier = $countryIdentifier;
      return $this;
    }

    /**
     * @return CountryIdentifierType
     */
    public function getCountryIdentifierType()
    {
      return $this->countryIdentifierType;
    }

    /**
     * @param CountryIdentifierType $countryIdentifierType
     * @return \Eurostop\Products\GetSkuPriceByCountryAndSku
     */
    public function setCountryIdentifierType($countryIdentifierType)
    {
      $this->countryIdentifierType = $countryIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->skuIdentifier;
    }

    /**
     * @param string $skuIdentifier
     * @return \Eurostop\Products\GetSkuPriceByCountryAndSku
     */
    public function setSkuIdentifier($skuIdentifier)
    {
      $this->skuIdentifier = $skuIdentifier;
      return $this;
    }

    /**
     * @return SkuIdentifierType
     */
    public function getSkuIdentifierType()
    {
      return $this->skuIdentifierType;
    }

    /**
     * @param SkuIdentifierType $skuIdentifierType
     * @return \Eurostop\Products\GetSkuPriceByCountryAndSku
     */
    public function setSkuIdentifierType($skuIdentifierType)
    {
      $this->skuIdentifierType = $skuIdentifierType;
      return $this;
    }

}
