<?php

namespace Eurostop\Products;

class GetSize
{

    /**
     * @var string $sizeIdentifier
     */
    protected $sizeIdentifier = null;

    /**
     * @var SizeIdentifierType $sizeIdentifierType
     */
    protected $sizeIdentifierType = null;

    /**
     * @var string $cultureCode
     */
    protected $cultureCode = null;

    /**
     * @param string $sizeIdentifier
     * @param SizeIdentifierType $sizeIdentifierType
     * @param string $cultureCode
     */
    public function __construct($sizeIdentifier = null, $sizeIdentifierType = null, $cultureCode = null)
    {
      $this->sizeIdentifier = $sizeIdentifier;
      $this->sizeIdentifierType = $sizeIdentifierType;
      $this->cultureCode = $cultureCode;
    }

    /**
     * @return string
     */
    public function getSizeIdentifier()
    {
      return $this->sizeIdentifier;
    }

    /**
     * @param string $sizeIdentifier
     * @return \Eurostop\Products\GetSize
     */
    public function setSizeIdentifier($sizeIdentifier)
    {
      $this->sizeIdentifier = $sizeIdentifier;
      return $this;
    }

    /**
     * @return SizeIdentifierType
     */
    public function getSizeIdentifierType()
    {
      return $this->sizeIdentifierType;
    }

    /**
     * @param SizeIdentifierType $sizeIdentifierType
     * @return \Eurostop\Products\GetSize
     */
    public function setSizeIdentifierType($sizeIdentifierType)
    {
      $this->sizeIdentifierType = $sizeIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getCultureCode()
    {
      return $this->cultureCode;
    }

    /**
     * @param string $cultureCode
     * @return \Eurostop\Products\GetSize
     */
    public function setCultureCode($cultureCode)
    {
      $this->cultureCode = $cultureCode;
      return $this;
    }

}
