<?php

namespace Eurostop\Products;

class GetProductsModifiedSinceDateCustom
{

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @var boolean $detectProductsModifiedSinceDate
     */
    protected $detectProductsModifiedSinceDate = null;

    /**
     * @var boolean $detectSkusModifiedSinceDate
     */
    protected $detectSkusModifiedSinceDate = null;

    /**
     * @var boolean $returnAnalysisValues
     */
    protected $returnAnalysisValues = null;

    /**
     * @var boolean $returnExtendedAttributeValues
     */
    protected $returnExtendedAttributeValues = null;

    /**
     * @var string $cultureCode
     */
    protected $cultureCode = null;

    /**
     * @var \DateTime $modifiedUntilDate
     */
    protected $modifiedUntilDate = null;

    /**
     * @param \DateTime $modifiedSinceDate
     * @param boolean $detectProductsModifiedSinceDate
     * @param boolean $detectSkusModifiedSinceDate
     * @param boolean $returnAnalysisValues
     * @param boolean $returnExtendedAttributeValues
     * @param string $cultureCode
     * @param \DateTime $modifiedUntilDate
     */
    public function __construct(\DateTime $modifiedSinceDate, $detectProductsModifiedSinceDate, $detectSkusModifiedSinceDate, $returnAnalysisValues, $returnExtendedAttributeValues, $cultureCode, \DateTime $modifiedUntilDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      $this->detectProductsModifiedSinceDate = $detectProductsModifiedSinceDate;
      $this->detectSkusModifiedSinceDate = $detectSkusModifiedSinceDate;
      $this->returnAnalysisValues = $returnAnalysisValues;
      $this->returnExtendedAttributeValues = $returnExtendedAttributeValues;
      $this->cultureCode = $cultureCode;
      $this->modifiedUntilDate = $modifiedUntilDate->format(\DateTime::ATOM);
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Products\GetProductsModifiedSinceDate
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getDetectProductsModifiedSinceDate()
    {
      return $this->detectProductsModifiedSinceDate;
    }

    /**
     * @param boolean $detectProductsModifiedSinceDate
     * @return \Eurostop\Products\GetProductsModifiedSinceDate
     */
    public function setDetectProductsModifiedSinceDate($detectProductsModifiedSinceDate)
    {
      $this->detectProductsModifiedSinceDate = $detectProductsModifiedSinceDate;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getDetectSkusModifiedSinceDate()
    {
      return $this->detectSkusModifiedSinceDate;
    }

    /**
     * @param boolean $detectSkusModifiedSinceDate
     * @return \Eurostop\Products\GetProductsModifiedSinceDate
     */
    public function setDetectSkusModifiedSinceDate($detectSkusModifiedSinceDate)
    {
      $this->detectSkusModifiedSinceDate = $detectSkusModifiedSinceDate;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getReturnAnalysisValues()
    {
      return $this->returnAnalysisValues;
    }

    /**
     * @param boolean $returnAnalysisValues
     * @return \Eurostop\Products\GetProductsModifiedSinceDate
     */
    public function setReturnAnalysisValues($returnAnalysisValues)
    {
      $this->returnAnalysisValues = $returnAnalysisValues;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getReturnExtendedAttributeValues()
    {
      return $this->returnExtendedAttributeValues;
    }

    /**
     * @param boolean $returnExtendedAttributeValues
     * @return \Eurostop\Products\GetProductsModifiedSinceDate
     */
    public function setReturnExtendedAttributeValues($returnExtendedAttributeValues)
    {
      $this->returnExtendedAttributeValues = $returnExtendedAttributeValues;
      return $this;
    }

    /**
     * @return string
     */
    public function getCultureCode()
    {
      return $this->cultureCode;
    }

    /**
     * @param string $cultureCode
     * @return \Eurostop\Products\GetProductsModifiedSinceDate
     */
    public function setCultureCode($cultureCode)
    {
      $this->cultureCode = $cultureCode;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedUntilDate()
    {
      if ($this->modifiedUntilDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedUntilDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedUntilDate
     * @return \Eurostop\Products\GetProductsModifiedSinceDate
     */
    public function setModifiedUntilDate(\DateTime $modifiedUntilDate)
    {
      $this->modifiedUntilDate = $modifiedUntilDate->format(\DateTime::ATOM);
      return $this;
    }

}
