<?php

namespace Eurostop\Products;

class GetProductsBySupplier
{

    /**
     * @var string $supplierIdentifier
     */
    protected $supplierIdentifier = null;

    /**
     * @var SupplierIdentifierType $supplierIdentifierType
     */
    protected $supplierIdentifierType = null;

    /**
     * @var boolean $returnAnalysisValues
     */
    protected $returnAnalysisValues = null;

    /**
     * @var boolean $returnExtendedAttributeValues
     */
    protected $returnExtendedAttributeValues = null;

    /**
     * @var string $cultureCode
     */
    protected $cultureCode = null;

    /**
     * @param string $supplierIdentifier
     * @param SupplierIdentifierType $supplierIdentifierType
     * @param boolean $returnAnalysisValues
     * @param boolean $returnExtendedAttributeValues
     * @param string $cultureCode
     */
    public function __construct($supplierIdentifier = null, $supplierIdentifierType = null, $returnAnalysisValues = null, $returnExtendedAttributeValues = null, $cultureCode = null)
    {
      $this->supplierIdentifier = $supplierIdentifier;
      $this->supplierIdentifierType = $supplierIdentifierType;
      $this->returnAnalysisValues = $returnAnalysisValues;
      $this->returnExtendedAttributeValues = $returnExtendedAttributeValues;
      $this->cultureCode = $cultureCode;
    }

    /**
     * @return string
     */
    public function getSupplierIdentifier()
    {
      return $this->supplierIdentifier;
    }

    /**
     * @param string $supplierIdentifier
     * @return \Eurostop\Products\GetProductsBySupplier
     */
    public function setSupplierIdentifier($supplierIdentifier)
    {
      $this->supplierIdentifier = $supplierIdentifier;
      return $this;
    }

    /**
     * @return SupplierIdentifierType
     */
    public function getSupplierIdentifierType()
    {
      return $this->supplierIdentifierType;
    }

    /**
     * @param SupplierIdentifierType $supplierIdentifierType
     * @return \Eurostop\Products\GetProductsBySupplier
     */
    public function setSupplierIdentifierType($supplierIdentifierType)
    {
      $this->supplierIdentifierType = $supplierIdentifierType;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getReturnAnalysisValues()
    {
      return $this->returnAnalysisValues;
    }

    /**
     * @param boolean $returnAnalysisValues
     * @return \Eurostop\Products\GetProductsBySupplier
     */
    public function setReturnAnalysisValues($returnAnalysisValues)
    {
      $this->returnAnalysisValues = $returnAnalysisValues;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getReturnExtendedAttributeValues()
    {
      return $this->returnExtendedAttributeValues;
    }

    /**
     * @param boolean $returnExtendedAttributeValues
     * @return \Eurostop\Products\GetProductsBySupplier
     */
    public function setReturnExtendedAttributeValues($returnExtendedAttributeValues)
    {
      $this->returnExtendedAttributeValues = $returnExtendedAttributeValues;
      return $this;
    }

    /**
     * @return string
     */
    public function getCultureCode()
    {
      return $this->cultureCode;
    }

    /**
     * @param string $cultureCode
     * @return \Eurostop\Products\GetProductsBySupplier
     */
    public function setCultureCode($cultureCode)
    {
      $this->cultureCode = $cultureCode;
      return $this;
    }

}
