<?php

namespace Eurostop\Products;

class GetBranchSkuTaxByProduct
{

    /**
     * @var string $productIdentifier
     */
    protected $productIdentifier = null;

    /**
     * @var ProductIdentifierType $productIdentifierType
     */
    protected $productIdentifierType = null;

    /**
     * @param string $productIdentifier
     * @param ProductIdentifierType $productIdentifierType
     */
    public function __construct($productIdentifier = null, $productIdentifierType = null)
    {
      $this->productIdentifier = $productIdentifier;
      $this->productIdentifierType = $productIdentifierType;
    }

    /**
     * @return string
     */
    public function getProductIdentifier()
    {
      return $this->productIdentifier;
    }

    /**
     * @param string $productIdentifier
     * @return \Eurostop\Products\GetBranchSkuTaxByProduct
     */
    public function setProductIdentifier($productIdentifier)
    {
      $this->productIdentifier = $productIdentifier;
      return $this;
    }

    /**
     * @return ProductIdentifierType
     */
    public function getProductIdentifierType()
    {
      return $this->productIdentifierType;
    }

    /**
     * @param ProductIdentifierType $productIdentifierType
     * @return \Eurostop\Products\GetBranchSkuTaxByProduct
     */
    public function setProductIdentifierType($productIdentifierType)
    {
      $this->productIdentifierType = $productIdentifierType;
      return $this;
    }

}
