<?php

namespace Eurostop\Products;

class GetBranchSkuTaxByBranchAndProductCustom
{

    /**
     * @var string $branchIdentifier
     */
    protected $branchIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var string $productIdentifier
     */
    protected $productIdentifier = null;

    /**
     * @var ProductIdentifierType $productIdentifierType
     */
    protected $productIdentifierType = null;

    /**
     * @param string $branchIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param string $productIdentifier
     * @param ProductIdentifierType $productIdentifierType
     */
    public function __construct($branchIdentifier, $branchIdentifierType, $productIdentifier, $productIdentifierType)
    {
      $this->branchIdentifier = $branchIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->productIdentifier = $productIdentifier;
      $this->productIdentifierType = $productIdentifierType;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->branchIdentifier;
    }

    /**
     * @param string $branchIdentifier
     * @return \Eurostop\Products\GetBranchSkuTaxByBranchAndProduct
     */
    public function setBranchIdentifier($branchIdentifier)
    {
      $this->branchIdentifier = $branchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Products\GetBranchSkuTaxByBranchAndProduct
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getProductIdentifier()
    {
      return $this->productIdentifier;
    }

    /**
     * @param string $productIdentifier
     * @return \Eurostop\Products\GetBranchSkuTaxByBranchAndProduct
     */
    public function setProductIdentifier($productIdentifier)
    {
      $this->productIdentifier = $productIdentifier;
      return $this;
    }

    /**
     * @return ProductIdentifierType
     */
    public function getProductIdentifierType()
    {
      return $this->productIdentifierType;
    }

    /**
     * @param ProductIdentifierType $productIdentifierType
     * @return \Eurostop\Products\GetBranchSkuTaxByBranchAndProduct
     */
    public function setProductIdentifierType($productIdentifierType)
    {
      $this->productIdentifierType = $productIdentifierType;
      return $this;
    }

}
