<?php

namespace Eurostop\Products;

class DeleteHierarchyNode
{

    /**
     * @var string $hierarchyNodeIdentifier
     */
    protected $hierarchyNodeIdentifier = null;

    /**
     * @var HierarchyNodeIdentifierType $hierarchyNodeIdentifierType
     */
    protected $hierarchyNodeIdentifierType = null;

    /**
     * @var int $levelNumber
     */
    protected $levelNumber = null;

    /**
     * @var string $level1ParentIdentifier
     */
    protected $level1ParentIdentifier = null;

    /**
     * @var string $level2ParentIdentifier
     */
    protected $level2ParentIdentifier = null;

    /**
     * @var string $level3ParentIdentifier
     */
    protected $level3ParentIdentifier = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param string $hierarchyNodeIdentifier
     * @param HierarchyNodeIdentifierType $hierarchyNodeIdentifierType
     * @param int $levelNumber
     * @param string $level1ParentIdentifier
     * @param string $level2ParentIdentifier
     * @param string $level3ParentIdentifier
     * @param string $submissionReference
     */
    public function __construct($hierarchyNodeIdentifier = null, $hierarchyNodeIdentifierType = null, $levelNumber = null, $level1ParentIdentifier = null, $level2ParentIdentifier = null, $level3ParentIdentifier = null, $submissionReference = null)
    {
      $this->hierarchyNodeIdentifier = $hierarchyNodeIdentifier;
      $this->hierarchyNodeIdentifierType = $hierarchyNodeIdentifierType;
      $this->levelNumber = $levelNumber;
      $this->level1ParentIdentifier = $level1ParentIdentifier;
      $this->level2ParentIdentifier = $level2ParentIdentifier;
      $this->level3ParentIdentifier = $level3ParentIdentifier;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return string
     */
    public function getHierarchyNodeIdentifier()
    {
      return $this->hierarchyNodeIdentifier;
    }

    /**
     * @param string $hierarchyNodeIdentifier
     * @return \Eurostop\Products\DeleteHierarchyNode
     */
    public function setHierarchyNodeIdentifier($hierarchyNodeIdentifier)
    {
      $this->hierarchyNodeIdentifier = $hierarchyNodeIdentifier;
      return $this;
    }

    /**
     * @return HierarchyNodeIdentifierType
     */
    public function getHierarchyNodeIdentifierType()
    {
      return $this->hierarchyNodeIdentifierType;
    }

    /**
     * @param HierarchyNodeIdentifierType $hierarchyNodeIdentifierType
     * @return \Eurostop\Products\DeleteHierarchyNode
     */
    public function setHierarchyNodeIdentifierType($hierarchyNodeIdentifierType)
    {
      $this->hierarchyNodeIdentifierType = $hierarchyNodeIdentifierType;
      return $this;
    }

    /**
     * @return int
     */
    public function getLevelNumber()
    {
      return $this->levelNumber;
    }

    /**
     * @param int $levelNumber
     * @return \Eurostop\Products\DeleteHierarchyNode
     */
    public function setLevelNumber($levelNumber)
    {
      $this->levelNumber = $levelNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getLevel1ParentIdentifier()
    {
      return $this->level1ParentIdentifier;
    }

    /**
     * @param string $level1ParentIdentifier
     * @return \Eurostop\Products\DeleteHierarchyNode
     */
    public function setLevel1ParentIdentifier($level1ParentIdentifier)
    {
      $this->level1ParentIdentifier = $level1ParentIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getLevel2ParentIdentifier()
    {
      return $this->level2ParentIdentifier;
    }

    /**
     * @param string $level2ParentIdentifier
     * @return \Eurostop\Products\DeleteHierarchyNode
     */
    public function setLevel2ParentIdentifier($level2ParentIdentifier)
    {
      $this->level2ParentIdentifier = $level2ParentIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getLevel3ParentIdentifier()
    {
      return $this->level3ParentIdentifier;
    }

    /**
     * @param string $level3ParentIdentifier
     * @return \Eurostop\Products\DeleteHierarchyNode
     */
    public function setLevel3ParentIdentifier($level3ParentIdentifier)
    {
      $this->level3ParentIdentifier = $level3ParentIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\DeleteHierarchyNode
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
