<?php

namespace Eurostop\Products;

class DeleteAnalysisValue
{

    /**
     * @var string $analysisTypeIdentifier
     */
    protected $analysisTypeIdentifier = null;

    /**
     * @var AnalysisTypeIdentifierType $analysisTypeIdentifierType
     */
    protected $analysisTypeIdentifierType = null;

    /**
     * @var string $analysisValueIdentifier
     */
    protected $analysisValueIdentifier = null;

    /**
     * @var AnalysisValueIdentifierType $analysisValueIdentifierType
     */
    protected $analysisValueIdentifierType = null;

    /**
     * @var boolean $applyToProducts
     */
    protected $applyToProducts = null;

    /**
     * @var boolean $applyToSkus
     */
    protected $applyToSkus = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param string $analysisTypeIdentifier
     * @param AnalysisTypeIdentifierType $analysisTypeIdentifierType
     * @param string $analysisValueIdentifier
     * @param AnalysisValueIdentifierType $analysisValueIdentifierType
     * @param boolean $applyToProducts
     * @param boolean $applyToSkus
     * @param string $submissionReference
     */
    public function __construct($analysisTypeIdentifier = null, $analysisTypeIdentifierType = null, $analysisValueIdentifier = null, $analysisValueIdentifierType = null, $applyToProducts = null, $applyToSkus = null, $submissionReference = null)
    {
      $this->analysisTypeIdentifier = $analysisTypeIdentifier;
      $this->analysisTypeIdentifierType = $analysisTypeIdentifierType;
      $this->analysisValueIdentifier = $analysisValueIdentifier;
      $this->analysisValueIdentifierType = $analysisValueIdentifierType;
      $this->applyToProducts = $applyToProducts;
      $this->applyToSkus = $applyToSkus;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return string
     */
    public function getAnalysisTypeIdentifier()
    {
      return $this->analysisTypeIdentifier;
    }

    /**
     * @param string $analysisTypeIdentifier
     * @return \Eurostop\Products\DeleteAnalysisValue
     */
    public function setAnalysisTypeIdentifier($analysisTypeIdentifier)
    {
      $this->analysisTypeIdentifier = $analysisTypeIdentifier;
      return $this;
    }

    /**
     * @return AnalysisTypeIdentifierType
     */
    public function getAnalysisTypeIdentifierType()
    {
      return $this->analysisTypeIdentifierType;
    }

    /**
     * @param AnalysisTypeIdentifierType $analysisTypeIdentifierType
     * @return \Eurostop\Products\DeleteAnalysisValue
     */
    public function setAnalysisTypeIdentifierType($analysisTypeIdentifierType)
    {
      $this->analysisTypeIdentifierType = $analysisTypeIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getAnalysisValueIdentifier()
    {
      return $this->analysisValueIdentifier;
    }

    /**
     * @param string $analysisValueIdentifier
     * @return \Eurostop\Products\DeleteAnalysisValue
     */
    public function setAnalysisValueIdentifier($analysisValueIdentifier)
    {
      $this->analysisValueIdentifier = $analysisValueIdentifier;
      return $this;
    }

    /**
     * @return AnalysisValueIdentifierType
     */
    public function getAnalysisValueIdentifierType()
    {
      return $this->analysisValueIdentifierType;
    }

    /**
     * @param AnalysisValueIdentifierType $analysisValueIdentifierType
     * @return \Eurostop\Products\DeleteAnalysisValue
     */
    public function setAnalysisValueIdentifierType($analysisValueIdentifierType)
    {
      $this->analysisValueIdentifierType = $analysisValueIdentifierType;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getApplyToProducts()
    {
      return $this->applyToProducts;
    }

    /**
     * @param boolean $applyToProducts
     * @return \Eurostop\Products\DeleteAnalysisValue
     */
    public function setApplyToProducts($applyToProducts)
    {
      $this->applyToProducts = $applyToProducts;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getApplyToSkus()
    {
      return $this->applyToSkus;
    }

    /**
     * @param boolean $applyToSkus
     * @return \Eurostop\Products\DeleteAnalysisValue
     */
    public function setApplyToSkus($applyToSkus)
    {
      $this->applyToSkus = $applyToSkus;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\DeleteAnalysisValue
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
