<?php

namespace Eurostop\Products;

class BlankExistCode
{

    /**
     * @var string $skuIdentifier
     */
    protected $skuIdentifier = null;

    /**
     * @var SkuIdentifierType $skuIdentifierType
     */
    protected $skuIdentifierType = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param string $skuIdentifier
     * @param SkuIdentifierType $skuIdentifierType
     * @param string $submissionReference
     */
    public function __construct($skuIdentifier = null, $skuIdentifierType = null, $submissionReference = null)
    {
      $this->skuIdentifier = $skuIdentifier;
      $this->skuIdentifierType = $skuIdentifierType;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->skuIdentifier;
    }

    /**
     * @param string $skuIdentifier
     * @return \Eurostop\Products\BlankExistCode
     */
    public function setSkuIdentifier($skuIdentifier)
    {
      $this->skuIdentifier = $skuIdentifier;
      return $this;
    }

    /**
     * @return SkuIdentifierType
     */
    public function getSkuIdentifierType()
    {
      return $this->skuIdentifierType;
    }

    /**
     * @param SkuIdentifierType $skuIdentifierType
     * @return \Eurostop\Products\BlankExistCode
     */
    public function setSkuIdentifierType($skuIdentifierType)
    {
      $this->skuIdentifierType = $skuIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\BlankExistCode
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
