<?php

namespace Eurostop\Products;

class ArrayOfSupplierCustom implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var Supplier[] $Supplier
     */
    protected $Supplier = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return Supplier[]
     */
    public function getSupplier()
    {
      return $this->Supplier;
    }

    /**
     * @param Supplier[] $Supplier
     * @return \Eurostop\Products\ArrayOfSupplier
     */
    public function setSupplier(array $Supplier = null)
    {
      $this->Supplier = $Supplier;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->Supplier[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return Supplier
     */
    public function offsetGet($offset)
    {
      return $this->Supplier[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param Supplier $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->Supplier[] = $value;
      } else {
        $this->Supplier[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->Supplier[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return Supplier Return the current element
     */
    public function current()
    {
      return current($this->Supplier);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->Supplier);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->Supplier);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->Supplier);
    }

    /**
     * Countable implementation
     *
     * @return Supplier Return count of elements
     */
    public function count()
    {
      return count($this->Supplier);
    }

}
