<?php

namespace Eurostop\Products;

class ArrayOfSubmittedSupplierCustom implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var SubmittedSupplier[] $SubmittedSupplier
     */
    protected $SubmittedSupplier = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return SubmittedSupplier[]
     */
    public function getSubmittedSupplier()
    {
      return $this->SubmittedSupplier;
    }

    /**
     * @param SubmittedSupplier[] $SubmittedSupplier
     * @return \Eurostop\Products\ArrayOfSubmittedSupplier
     */
    public function setSubmittedSupplier(array $SubmittedSupplier = null)
    {
      $this->SubmittedSupplier = $SubmittedSupplier;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->SubmittedSupplier[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return SubmittedSupplier
     */
    public function offsetGet($offset)
    {
      return $this->SubmittedSupplier[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param SubmittedSupplier $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->SubmittedSupplier[] = $value;
      } else {
        $this->SubmittedSupplier[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->SubmittedSupplier[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return SubmittedSupplier Return the current element
     */
    public function current()
    {
      return current($this->SubmittedSupplier);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->SubmittedSupplier);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->SubmittedSupplier);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->SubmittedSupplier);
    }

    /**
     * Countable implementation
     *
     * @return SubmittedSupplier Return count of elements
     */
    public function count()
    {
      return count($this->SubmittedSupplier);
    }

}
