<?php

namespace Eurostop\Products;

class ArrayOfSubmittedSkuPriceCustom implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var SubmittedSkuPrice[] $SubmittedSkuPrice
     */
    protected $SubmittedSkuPrice = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return SubmittedSkuPrice[]
     */
    public function getSubmittedSkuPrice()
    {
      return $this->SubmittedSkuPrice;
    }

    /**
     * @param SubmittedSkuPrice[] $SubmittedSkuPrice
     * @return \Eurostop\Products\ArrayOfSubmittedSkuPrice
     */
    public function setSubmittedSkuPrice(array $SubmittedSkuPrice = null)
    {
      $this->SubmittedSkuPrice = $SubmittedSkuPrice;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->SubmittedSkuPrice[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return SubmittedSkuPrice
     */
    public function offsetGet($offset)
    {
      return $this->SubmittedSkuPrice[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param SubmittedSkuPrice $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->SubmittedSkuPrice[] = $value;
      } else {
        $this->SubmittedSkuPrice[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->SubmittedSkuPrice[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return SubmittedSkuPrice Return the current element
     */
    public function current()
    {
      return current($this->SubmittedSkuPrice);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->SubmittedSkuPrice);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->SubmittedSkuPrice);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->SubmittedSkuPrice);
    }

    /**
     * Countable implementation
     *
     * @return SubmittedSkuPrice Return count of elements
     */
    public function count()
    {
      return count($this->SubmittedSkuPrice);
    }

}
