<?php

namespace Eurostop\Products;

class ArrayOfSubmittedSizeCustom implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var SubmittedSize[] $SubmittedSize
     */
    protected $SubmittedSize = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return SubmittedSize[]
     */
    public function getSubmittedSize()
    {
      return $this->SubmittedSize;
    }

    /**
     * @param SubmittedSize[] $SubmittedSize
     * @return \Eurostop\Products\ArrayOfSubmittedSize
     */
    public function setSubmittedSize(array $SubmittedSize = null)
    {
      $this->SubmittedSize = $SubmittedSize;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->SubmittedSize[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return SubmittedSize
     */
    public function offsetGet($offset)
    {
      return $this->SubmittedSize[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param SubmittedSize $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->SubmittedSize[] = $value;
      } else {
        $this->SubmittedSize[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->SubmittedSize[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return SubmittedSize Return the current element
     */
    public function current()
    {
      return current($this->SubmittedSize);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->SubmittedSize);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->SubmittedSize);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->SubmittedSize);
    }

    /**
     * Countable implementation
     *
     * @return SubmittedSize Return count of elements
     */
    public function count()
    {
      return count($this->SubmittedSize);
    }

}
